/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.ThreadLocalRandom;

public class TransactionIdentifier {
    public static final int LENGTH = 24;
    private static final String HEX_ALPHABET = "0123456789abcdef";
    private static final char[] HEX_ENCODING = TransactionIdentifier.buildEncodingArray();

    private static char[] buildEncodingArray() {
        char[] encoding = new char[512];
        for (int i = 0; i < 256; ++i) {
            encoding[i] = HEX_ALPHABET.charAt(i >>> 4);
            encoding[i | 0x100] = HEX_ALPHABET.charAt(i & 0xF);
        }
        return encoding;
    }

    public static String generate() {
        byte[] bytes = new byte[12];
        ThreadLocalRandom.current().nextBytes(bytes);
        char[] chars = new char[24];
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            chars[i * 2] = HEX_ENCODING[v];
            chars[i * 2 + 1] = HEX_ENCODING[v | 0x100];
        }
        return new String(chars);
    }
}

