/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.preprocess.DiscoRunnableDecorator;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ThreadInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ThreadInterceptor.class);

    ThreadInterceptor() {
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).ignore(ElementMatchers.noneOf(new Type[]{Thread.class})).type(ThreadInterceptor.createThreadTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit(Advice.to(StartAdvice.class).on(ThreadInterceptor.createStartMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createThreadTypeMatcher() {
        return ElementMatchers.is(Thread.class);
    }

    static ElementMatcher.Junction<? super MethodDescription> createStartMethodMatcher() {
        return ElementMatchers.named("start");
    }

    public static class StartAdvice {
        @Advice.OnMethodEnter
        public static void onStartEnter(@Advice.FieldValue(value="target", readOnly=false) Runnable target) {
            target = DiscoRunnableDecorator.maybeDecorate(target);
        }
    }
}

