/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.web.apache.event;

import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import software.amazon.disco.agent.event.HttpServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.HttpServiceDownstreamResponseEvent;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.web.apache.event.ApacheHttpServiceDownstreamRequestEvent;

public class ApacheEventFactory {
    public static HttpServiceDownstreamRequestEvent createDownstreamRequestEvent(String origin, HttpRequest request) {
        String uri = null;
        String method = null;
        if (request instanceof HttpRequestBase) {
            HttpRequestBase baseRequest = (HttpRequestBase)request;
            if (baseRequest.getURI() != null) {
                uri = baseRequest.getURI().toString();
            }
            method = baseRequest.getMethod();
        } else if (request.getRequestLine() != null) {
            uri = request.getRequestLine().getUri();
            method = request.getRequestLine().getMethod();
        }
        ApacheHttpServiceDownstreamRequestEvent requestEvent = new ApacheHttpServiceDownstreamRequestEvent(origin, uri, method, request);
        requestEvent.withMethod(method);
        requestEvent.withUri(uri);
        return requestEvent;
    }

    public static ServiceDownstreamResponseEvent createServiceResponseEvent(HttpResponse response, ServiceDownstreamRequestEvent requestEvent, Throwable throwable) {
        HttpServiceDownstreamResponseEvent responseEvent = new HttpServiceDownstreamResponseEvent(requestEvent.getOrigin(), requestEvent.getService(), requestEvent.getOperation(), requestEvent);
        if (throwable != null) {
            responseEvent.withThrown(throwable);
        }
        if (response != null) {
            if (response.getStatusLine() != null) {
                responseEvent.withStatusCode(response.getStatusLine().getStatusCode());
            }
            if (response.getEntity() != null) {
                responseEvent.withContentLength(response.getEntity().getContentLength());
            }
        }
        return responseEvent;
    }
}

