/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.sql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import software.amazon.disco.agent.event.AbstractServiceRequestEvent;
import software.amazon.disco.agent.event.AbstractServiceResponseEvent;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.event.ServiceRequestEvent;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class JdbcExecuteInterceptor
implements Installable {
    public static final Logger log = LogManager.getLogger(JdbcExecuteInterceptor.class);
    public static final String SQL_ORIGIN = "SQL";

    @Advice.OnMethodEnter
    public static ServiceRequestEvent enter(@Advice.AllArguments Object[] args, @Advice.Origin String origin, @Advice.This Statement stmt) {
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(Sql) interception of " + origin);
        }
        String query = null;
        String db = null;
        try {
            query = JdbcExecuteInterceptor.parseQueryFromStatement(stmt, args);
        }
        catch (Exception e) {
            log.warn("Disco(Sql) failed to retrieve query string for SQL Downstream Service event", (Throwable)e);
        }
        try {
            db = stmt.getConnection().getCatalog();
        }
        catch (Exception e) {
            log.warn("Disco(Sql) failed to retrieve Database name for SQL Downstream Service event", (Throwable)e);
        }
        AbstractServiceRequestEvent requestEvent = new ServiceDownstreamRequestEvent(SQL_ORIGIN, db, query).withRequest((Object)stmt);
        EventBus.publish((Event)requestEvent);
        return requestEvent;
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class)
    public static void exit(@Advice.Enter ServiceRequestEvent requestEvent, @Advice.Return Object response, @Advice.Thrown Throwable thrown) {
        AbstractServiceResponseEvent responseEvent = new ServiceDownstreamResponseEvent(SQL_ORIGIN, requestEvent.getService(), requestEvent.getOperation(), requestEvent).withResponse(response).withThrown(thrown);
        EventBus.publish((Event)responseEvent);
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(JdbcExecuteInterceptor.buildClassMatcher()).transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice().advice(JdbcExecuteInterceptor.buildMethodMatcher(), JdbcExecuteInterceptor.class.getName()));
    }

    public static String parseQueryFromStatement(Statement stmt, Object[] params) throws NoSuchMethodException {
        String query = null;
        if (params != null && params.length > 0 && params[0] instanceof String) {
            query = (String)params[0];
        } else if (stmt instanceof PreparedStatement && Statement.class.isAssignableFrom(stmt.getClass().getMethod("toString", new Class[0]).getDeclaringClass())) {
            query = stmt.toString();
        }
        return query;
    }

    static ElementMatcher<? super TypeDescription> buildClassMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.sql.Statement")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
    }

    static ElementMatcher<? super MethodDescription> buildMethodMatcher() {
        ElementMatcher.Junction preparedStatementMatcher = ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.sql.PreparedStatement")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface()));
        ElementMatcher.Junction takesNoArgsMatcher = ElementMatchers.isDeclaredBy((ElementMatcher)preparedStatementMatcher).and((ElementMatcher)ElementMatchers.takesArguments((int)0));
        ElementMatcher.Junction takesSqlArgMatcher = ElementMatchers.isDeclaredBy(JdbcExecuteInterceptor.buildClassMatcher()).and((ElementMatcher)ElementMatchers.takesArgument((int)0, String.class));
        ElementMatcher.Junction executeMatcher = ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.returns(Boolean.TYPE));
        ElementMatcher.Junction executeUpdateMatcher = ElementMatchers.named((String)"executeUpdate").and((ElementMatcher)ElementMatchers.returns(Integer.TYPE));
        ElementMatcher.Junction executeLargeUpdateMatcher = ElementMatchers.named((String)"executeLargeUpdate").and((ElementMatcher)ElementMatchers.returns(Long.TYPE));
        ElementMatcher.Junction executeQueryMatcher = ElementMatchers.named((String)"executeQuery").and((ElementMatcher)ElementMatchers.returns(ResultSet.class));
        ElementMatcher.Junction methodNameMatches = executeMatcher.or((ElementMatcher)executeUpdateMatcher).or((ElementMatcher)executeQueryMatcher).or((ElementMatcher)executeLargeUpdateMatcher);
        ElementMatcher.Junction argumentTypesCorrect = takesNoArgsMatcher.or((ElementMatcher)takesSqlArgMatcher);
        return methodNameMatches.and((ElementMatcher)argumentTypesCorrect).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }
}

