/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.plugin.PluginDiscovery;
import software.amazon.disco.instrumentation.preprocess.util.JarSigningVerificationOutcome;

public class FileUtils {
    private static final Logger logger = LogManager.getLogger(FileUtils.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readEntryFromJar(JarFile jarfile, JarEntry entry) {
        try (InputStream entryStream = jarfile.getInputStream(entry);){
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int len = entryStream.read(buffer);
            while (len != -1) {
                os.write(buffer, 0, len);
                len = entryStream.read(buffer);
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(entry.getName(), e);
        }
    }

    public static JarSigningVerificationOutcome verifyJar(File file) {
        logger.debug("Disco(Instrumentation preprocess) - Verifying Jar: " + file.getAbsolutePath());
        File javaHomeDir = new File(System.getProperty("java.home"));
        File jarSignerDir = javaHomeDir.getAbsolutePath().endsWith("jre") ? new File(javaHomeDir.getParentFile(), "bin") : new File(javaHomeDir, "bin");
        ProcessBuilder processBuilder = new ProcessBuilder(jarSignerDir + "/jarsigner", "-verify", file.getAbsolutePath());
        try {
            Process process = processBuilder.start();
            processBuilder.redirectErrorStream(true);
            int exitCode = process.waitFor();
            String result = FileUtils.readInputStream(process.getInputStream());
            logger.trace("Disco(Instrumentation preprocess) - Jar verification exit code is: " + exitCode);
            logger.trace("Disco(Instrumentation preprocess) - Jar verification output message:\n " + result);
            if (exitCode == 0) {
                return result.contains("jar is unsigned.") ? JarSigningVerificationOutcome.UNSIGNED : JarSigningVerificationOutcome.SIGNED;
            }
            return JarSigningVerificationOutcome.INVALID;
        }
        catch (IOException | InterruptedException e) {
            logger.warn("Disco(Instrumentation preprocess) - Failed to verify Jar: " + file.getAbsolutePath(), e);
            return JarSigningVerificationOutcome.INVALID;
        }
    }

    public static File createTemporaryManifestFile(File temporaryManifestDir) throws IOException {
        if (!temporaryManifestDir.exists()) {
            temporaryManifestDir.mkdirs();
        }
        File manifest = new File(temporaryManifestDir, ManagementFactory.getRuntimeMXBean().getName());
        manifest.createNewFile();
        return manifest;
    }

    public static Set<File> scanPluginsFromAgentConfig(String agentConfig) {
        HashSet<File> pluginsDiscovered = new HashSet<File>();
        String pluginDirArgPair = Arrays.stream(agentConfig.split(":")).filter(arg -> arg.toLowerCase(Locale.ROOT).startsWith("pluginpath")).findFirst().get();
        if (pluginDirArgPair == null) {
            return pluginsDiscovered;
        }
        File pluginDir = new File(pluginDirArgPair.split("=")[1]);
        if (pluginDir.exists() && pluginDir.isDirectory()) {
            for (File plugin : pluginDir.listFiles(file -> file.getName().endsWith(".jar"))) {
                try {
                    if (PluginDiscovery.validateDiscoPlugin(plugin) == null) continue;
                    pluginsDiscovered.add(plugin);
                }
                catch (Exception e) {
                    logger.warn("Disco(Instrumentation preprocess) - Error occurred while validating plugin file: " + plugin.getAbsolutePath(), e);
                }
            }
        }
        return pluginsDiscovered;
    }

    private static String readInputStream(InputStream inputStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return reader.lines().collect(Collectors.joining(System.lineSeparator()));
    }
}

