/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class PreprocessOutputHandler {
    private static final Logger log = LogManager.getLogger(PreprocessOutputHandler.class);
    private static final String START_SEPARATOR = "- ";
    private static final String END_SEPARATOR = ": ";
    private final List<String> preprocessorOutputs;
    private final Map<String, Integer> summary = new LinkedHashMap<String, Integer>(){
        {
            this.put("Sources processed: ", 0);
            this.put("Sources instrumented: ", 0);
            this.put("Signed jars discovered: ", 0);
            this.put("Signed jars instrumented: ", 0);
            this.put("Sources containing classes with unresolvable dependencies: ", 0);
        }
    };

    public PreprocessOutputHandler(List<String> preprocessorOutputs) {
        this.preprocessorOutputs = preprocessorOutputs;
    }

    public void printPreprocessOutput() {
        this.processAllOutputs();
        this.logPreprocessSummary();
    }

    protected void processAllOutputs() {
        for (String preprocessorOutput : this.preprocessorOutputs) {
            log.info(preprocessorOutput);
            this.parsePreprocessorOutputAndUpdateSummary(preprocessorOutput);
        }
    }

    protected void parsePreprocessorOutputAndUpdateSummary(String preprocessorOutput) {
        try {
            int indexOfSummaryTitle = preprocessorOutput.indexOf("Preprocessing summary");
            String summaryContent = preprocessorOutput.substring(indexOfSummaryTitle);
            Scanner scanner = new Scanner(summaryContent);
            while (scanner.hasNextLine()) {
                int indexOfItemValue;
                int indexOfItemName;
                String item;
                String line = scanner.nextLine();
                if (line.contains("Preprocessing summary") || !line.contains(START_SEPARATOR) || !line.contains(END_SEPARATOR) || !this.summary.containsKey(item = line.substring(indexOfItemName = line.indexOf(START_SEPARATOR) + START_SEPARATOR.length(), indexOfItemValue = line.indexOf(END_SEPARATOR) + END_SEPARATOR.length()))) continue;
                int itemValue = Integer.parseInt(line.substring(indexOfItemValue));
                this.summary.put(item, this.summary.get(item) + itemValue);
            }
        }
        catch (Exception e) {
            log.warn("Failed to parse the preprocessor output" + e.getMessage());
        }
    }

    protected void logPreprocessSummary() {
        log.info("Disco(Instrumentation preprocess) - Preprocessing summary");
        for (Map.Entry<String, Integer> item : this.summary.entrySet()) {
            log.info("Disco(Instrumentation preprocess) - " + item.getKey() + item.getValue());
        }
    }

    public Map<String, Integer> getSummary() {
        return this.summary;
    }
}

