/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.ProcessInstrumentationAbortedException;
import software.amazon.disco.instrumentation.preprocess.multipreprocessor.ConfigPartitioner;
import software.amazon.disco.instrumentation.preprocess.multipreprocessor.PreprocessOutputHandler;
import software.amazon.disco.instrumentation.preprocess.multipreprocessor.PreprocessorArgumentsExporter;
import software.amazon.disco.instrumentation.preprocess.multipreprocessor.PreprocessorOutcome;

public class MultiPreprocessorScheduler {
    private static final Logger log = LogManager.getLogger(MultiPreprocessorScheduler.class);
    private final PreprocessConfig config;
    static final int UNUSED_PROCESSORS = 2;

    public void execute() throws ExecutionException, InterruptedException {
        int subPreprocessors = this.configureSubPreprocessors();
        List<String[]> preprocessorRawCommandlineArgsList = ConfigPartitioner.partitionConfig(this.config, subPreprocessors).stream().map(PreprocessConfig::toCommandlineArguments).collect(Collectors.toList());
        List<String> preprocessorCommandlineArgsList = new PreprocessorArgumentsExporter().exportArguments(preprocessorRawCommandlineArgsList, this.config, "tmp/worker_args");
        List<PreprocessorInvoker> preprocessorInvokers = preprocessorCommandlineArgsList.stream().map(x$0 -> new PreprocessorInvoker((String)x$0)).collect(Collectors.toList());
        log.info("Arranged " + preprocessorInvokers.size() + " workers to preprocess sources in parallel, this may take a few minutes to complete...");
        List<String> preprocessorOutputs = this.executePreprocessorInvokers(preprocessorInvokers);
        new PreprocessOutputHandler(preprocessorOutputs).printPreprocessOutput();
    }

    protected List<String> executePreprocessorInvokers(List<PreprocessorInvoker> preprocessorInvokers) throws InterruptedException, ExecutionException {
        ExecutorService taskExecutor = Executors.newCachedThreadPool();
        ArrayList<String> preprocessorOutputs = new ArrayList<String>();
        List results = taskExecutor.invokeAll(preprocessorInvokers);
        for (Future res : results) {
            PreprocessorOutcome preprocessorOutCome = (PreprocessorOutcome)res.get();
            int exitCode = preprocessorOutCome.getExitCode();
            String processorOutput = preprocessorOutCome.getPreprocessorOutput();
            if (exitCode != 0) {
                throw new ProcessInstrumentationAbortedException(exitCode, preprocessorOutCome.getCommandlineArgs(), processorOutput);
            }
            preprocessorOutputs.add(processorOutput);
        }
        taskExecutor.shutdown();
        return preprocessorOutputs;
    }

    protected int configureSubPreprocessors() {
        String subPreprocessors = this.config.getSubPreprocessors();
        if (subPreprocessors == null) {
            return this.calculateDefaultSubPreprocessors(Runtime.getRuntime());
        }
        return Integer.parseInt(subPreprocessors);
    }

    protected int calculateDefaultSubPreprocessors(Runtime runtime) {
        int availableProcessors = runtime.availableProcessors();
        return availableProcessors > 2 ? availableProcessors - 2 : availableProcessors;
    }

    protected static String readInputStream(InputStream inputStream) {
        return new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining(System.lineSeparator()));
    }

    MultiPreprocessorScheduler(PreprocessConfig config) {
        this.config = config;
    }

    public static MultiPreprocessorSchedulerBuilder builder() {
        return new MultiPreprocessorSchedulerBuilder();
    }

    public static class MultiPreprocessorSchedulerBuilder {
        private PreprocessConfig config;

        MultiPreprocessorSchedulerBuilder() {
        }

        public MultiPreprocessorSchedulerBuilder config(PreprocessConfig config) {
            this.config = config;
            return this;
        }

        public MultiPreprocessorScheduler build() {
            return new MultiPreprocessorScheduler(this.config);
        }

        public String toString() {
            return "MultiPreprocessorScheduler.MultiPreprocessorSchedulerBuilder(config=" + this.config + ")";
        }
    }

    public static class PreprocessorInvoker
    implements Callable<PreprocessorOutcome> {
        private final String preprocessorCommandlineArgs;

        private PreprocessorInvoker(String preprocessorCommandlineArgs) {
            this.preprocessorCommandlineArgs = preprocessorCommandlineArgs;
        }

        @Override
        public PreprocessorOutcome call() throws IOException, InterruptedException {
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            File javaHomeDir = new File(System.getProperty("java.home"));
            File javaDir = javaHomeDir.getAbsolutePath().endsWith("jre") ? new File(javaHomeDir.getParentFile(), "bin") : new File(javaHomeDir, "bin");
            ArrayList<String> commandList = new ArrayList<String>(Arrays.asList(javaDir + "/java", "-cp", System.getProperty("java.class.path"), "software.amazon.disco.instrumentation.preprocess.multipreprocessor.PreprocessorDriver"));
            commandList.add(this.preprocessorCommandlineArgs);
            processBuilder.command(commandList);
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            String processOutput = MultiPreprocessorScheduler.readInputStream(process.getInputStream());
            int exitCode = process.waitFor();
            return PreprocessorOutcome.builder().exitCode(exitCode).preprocessorOutput(processOutput).commandlineArgs(commandList.toArray(new String[0])).build();
        }
    }
}

