/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.multipreprocessor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;

public class ConfigPartitioner {
    public static List<PreprocessConfig> partitionConfig(PreprocessConfig config, int partitionNum) {
        ArrayList<PreprocessConfig> configs = new ArrayList<PreprocessConfig>();
        Map<String, Set<String>> sourcePaths = config.getSourcePaths();
        List<Map<String, Set<String>>> sourcePathsPartitions = ConfigPartitioner.partitionSourcePaths(sourcePaths, partitionNum);
        for (Map<String, Set<String>> sourcePathsPartition : sourcePathsPartitions) {
            configs.add(ConfigPartitioner.generatePreprocessorConfig(config, sourcePathsPartition, sourcePathsPartitions));
        }
        return configs;
    }

    protected static List<Map<String, Set<String>>> partitionSourcePaths(Map<String, Set<String>> sourcePaths, int partitionNum) {
        ArrayList<Map<String, Set<String>>> sourcePathsMaps = new ArrayList<Map<String, Set<String>>>();
        HashMap<String, List<List<String>>> partitionedSourcePaths = new HashMap<String, List<List<String>>>();
        for (Map.Entry<String, Set<String>> entry : sourcePaths.entrySet()) {
            ArrayList<String> sourcesAsList = new ArrayList<String>((Collection)entry.getValue());
            Collections.shuffle(sourcesAsList);
            List<List<String>> sourcesPartitions = ConfigPartitioner.partitionSources(sourcesAsList, partitionNum);
            if (sourcesPartitions.isEmpty()) continue;
            partitionedSourcePaths.put(entry.getKey(), sourcesPartitions);
        }
        for (int i = 0; i < partitionNum; ++i) {
            HashMap sourcePathsPartition = new HashMap();
            for (Map.Entry entry : partitionedSourcePaths.entrySet()) {
                if (i >= ((List)entry.getValue()).size()) continue;
                sourcePathsPartition.put(entry.getKey(), new HashSet((List)((List)entry.getValue()).get(i)));
            }
            if (sourcePathsPartition.isEmpty()) break;
            sourcePathsMaps.add(sourcePathsPartition);
        }
        return sourcePathsMaps;
    }

    protected static List<List<String>> partitionSources(List<String> sources, int partitionNum) {
        ArrayList<List<String>> sourcesPartitions = new ArrayList<List<String>>();
        if (sources.isEmpty()) {
            return sourcesPartitions;
        }
        int size = sources.size();
        int numOfPartitions = Math.min(size, partitionNum);
        int partitionSize = size / numOfPartitions;
        int remainder = size % numOfPartitions;
        int startIndex = 0;
        while (startIndex < size) {
            int endIndex = startIndex + partitionSize;
            if (remainder > 0) {
                ++endIndex;
                --remainder;
            }
            endIndex = Math.min(endIndex, size);
            sourcesPartitions.add(sources.subList(startIndex, endIndex));
            startIndex = endIndex;
        }
        return sourcesPartitions;
    }

    protected static PreprocessConfig generatePreprocessorConfig(PreprocessConfig config, Map<String, Set<String>> sourcePaths, List<Map<String, Set<String>>> sourcePathsPartitions) {
        int index = sourcePathsPartitions.indexOf(sourcePaths);
        int lastIndex = sourcePathsPartitions.size() - 1;
        PreprocessConfig clonedConfig = config.toBuilder().build();
        clonedConfig.setSourcePaths(null);
        PreprocessConfig.PreprocessConfigBuilder configBuilder = clonedConfig.toBuilder();
        configBuilder.sourcePaths(sourcePaths);
        if (config.getJdkPath() != null && index < lastIndex) {
            configBuilder.jdkPath(null);
        }
        return configBuilder.build();
    }
}

