/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentSignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.SignedJarHandlingStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.CacheStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.NoOpCacheStrategy;

public class PreprocessConfig {
    private Map<String, Set<String>> sourcePaths;
    private SignedJarHandlingStrategy signedJarHandlingStrategy;
    private final String subPreprocessors;
    private final String outputDir;
    private final String agentPath;
    private final String suffix;
    private final Logger.Level logLevel;
    private final String javaVersion;
    private final String agentArg;
    private final boolean failOnUnresolvableDependency;
    private String jdkPath;
    private CacheStrategy cacheStrategy;

    public Logger.Level getLogLevel() {
        if (this.logLevel == null) {
            return Logger.Level.INFO;
        }
        return this.logLevel;
    }

    public SignedJarHandlingStrategy getSignedJarHandlingStrategy() {
        if (this.signedJarHandlingStrategy == null) {
            this.signedJarHandlingStrategy = new InstrumentSignedJarHandlingStrategy();
        }
        return this.signedJarHandlingStrategy;
    }

    public String[] toCommandlineArguments() {
        ArrayList<String> commandlineArguments = new ArrayList<String>();
        for (Map.Entry<String, Set<String>> entry : this.sourcePaths.entrySet()) {
            Set<String> sources = entry.getValue();
            sources.remove("");
            if (sources.isEmpty()) continue;
            commandlineArguments.add("--sourcepaths");
            StringBuilder builder = new StringBuilder();
            builder.append(String.join((CharSequence)":", sources)).append(entry.getKey().isEmpty() ? "" : "@").append(entry.getKey());
            commandlineArguments.add(builder.toString());
        }
        if (this.signedJarHandlingStrategy != null) {
            commandlineArguments.add("--signedjarhandlingstrategy");
            commandlineArguments.add(this.signedJarHandlingStrategy.getSimpleName());
        }
        if (this.outputDir != null) {
            commandlineArguments.add("--outputdir");
            commandlineArguments.add(this.outputDir);
        }
        if (this.agentPath != null) {
            commandlineArguments.add("--agentpath");
            commandlineArguments.add(this.agentPath);
        }
        if (this.suffix != null) {
            commandlineArguments.add("--suffix");
            commandlineArguments.add(this.suffix);
        }
        if (this.logLevel != null) {
            switch (this.logLevel) {
                case DEBUG: {
                    commandlineArguments.add("--verbose");
                    break;
                }
                case TRACE: {
                    commandlineArguments.add("--extraverbose");
                    break;
                }
                case FATAL: {
                    commandlineArguments.add("--silent");
                    break;
                }
            }
        }
        if (this.javaVersion != null) {
            commandlineArguments.add("--javaversion");
            commandlineArguments.add(this.javaVersion);
        }
        if (this.agentArg != null) {
            commandlineArguments.add("--agentarg");
            commandlineArguments.add(this.agentArg);
        }
        if (this.jdkPath != null) {
            commandlineArguments.add("--jdksupport");
            commandlineArguments.add(this.jdkPath);
        }
        if (this.failOnUnresolvableDependency) {
            commandlineArguments.add("--failonunresolvabledependency");
        }
        if (!(this.getCacheStrategy() instanceof NoOpCacheStrategy)) {
            commandlineArguments.add("--cachestrategy");
            commandlineArguments.add(this.getCacheStrategy().getSimpleName());
        }
        return commandlineArguments.toArray(new String[0]);
    }

    public CacheStrategy getCacheStrategy() {
        return this.cacheStrategy == null ? new NoOpCacheStrategy() : this.cacheStrategy;
    }

    public String toStringForCaching() {
        return "PreprocessConfig{, signedJarHandlingStrategy=" + this.getSignedJarHandlingStrategy().getClass().getName() + ", outputDir='" + this.outputDir + '\'' + ", agentPath='" + this.agentPath + '\'' + ", suffix='" + this.suffix + '\'' + ", javaVersion='" + this.javaVersion + '\'' + ", agentArg='" + this.agentArg + '\'' + ", failOnUnresolvableDependency=" + this.failOnUnresolvableDependency + ", cacheStrategy=" + this.getCacheStrategy().getSimpleName() + '}';
    }

    PreprocessConfig(Map<String, Set<String>> sourcePaths, SignedJarHandlingStrategy signedJarHandlingStrategy, String subPreprocessors, String outputDir, String agentPath, String suffix, Logger.Level logLevel, String javaVersion, String agentArg, boolean failOnUnresolvableDependency, String jdkPath, CacheStrategy cacheStrategy) {
        this.sourcePaths = sourcePaths;
        this.signedJarHandlingStrategy = signedJarHandlingStrategy;
        this.subPreprocessors = subPreprocessors;
        this.outputDir = outputDir;
        this.agentPath = agentPath;
        this.suffix = suffix;
        this.logLevel = logLevel;
        this.javaVersion = javaVersion;
        this.agentArg = agentArg;
        this.failOnUnresolvableDependency = failOnUnresolvableDependency;
        this.jdkPath = jdkPath;
        this.cacheStrategy = cacheStrategy;
    }

    public static PreprocessConfigBuilder builder() {
        return new PreprocessConfigBuilder();
    }

    public PreprocessConfigBuilder toBuilder() {
        PreprocessConfigBuilder builder = new PreprocessConfigBuilder().signedJarHandlingStrategy(this.signedJarHandlingStrategy).subPreprocessors(this.subPreprocessors).outputDir(this.outputDir).agentPath(this.agentPath).suffix(this.suffix).logLevel(this.logLevel).javaVersion(this.javaVersion).agentArg(this.agentArg).failOnUnresolvableDependency(this.failOnUnresolvableDependency).jdkPath(this.jdkPath).cacheStrategy(this.cacheStrategy);
        if (this.sourcePaths != null) {
            builder.sourcePaths(this.sourcePaths);
        }
        return builder;
    }

    public Map<String, Set<String>> getSourcePaths() {
        return this.sourcePaths;
    }

    public String getSubPreprocessors() {
        return this.subPreprocessors;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public String getAgentPath() {
        return this.agentPath;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public String getAgentArg() {
        return this.agentArg;
    }

    public boolean isFailOnUnresolvableDependency() {
        return this.failOnUnresolvableDependency;
    }

    public String getJdkPath() {
        return this.jdkPath;
    }

    public void setSourcePaths(Map<String, Set<String>> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setJdkPath(String jdkPath) {
        this.jdkPath = jdkPath;
    }

    public void setCacheStrategy(CacheStrategy cacheStrategy) {
        this.cacheStrategy = cacheStrategy;
    }

    public static class PreprocessConfigBuilder {
        private ArrayList<String> sourcePaths$key;
        private ArrayList<Set<String>> sourcePaths$value;
        private SignedJarHandlingStrategy signedJarHandlingStrategy;
        private String subPreprocessors;
        private String outputDir;
        private String agentPath;
        private String suffix;
        private Logger.Level logLevel;
        private String javaVersion;
        private String agentArg;
        private boolean failOnUnresolvableDependency;
        private String jdkPath;
        private CacheStrategy cacheStrategy;

        PreprocessConfigBuilder() {
        }

        public PreprocessConfigBuilder sourcePath(String sourcePathKey, Set<String> sourcePathValue) {
            if (this.sourcePaths$key == null) {
                this.sourcePaths$key = new ArrayList();
                this.sourcePaths$value = new ArrayList();
            }
            this.sourcePaths$key.add(sourcePathKey);
            this.sourcePaths$value.add(sourcePathValue);
            return this;
        }

        public PreprocessConfigBuilder sourcePaths(Map<? extends String, ? extends Set<String>> sourcePaths) {
            if (sourcePaths == null) {
                throw new NullPointerException("sourcePaths cannot be null");
            }
            if (this.sourcePaths$key == null) {
                this.sourcePaths$key = new ArrayList();
                this.sourcePaths$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Set<String>> $lombokEntry : sourcePaths.entrySet()) {
                this.sourcePaths$key.add($lombokEntry.getKey());
                this.sourcePaths$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public PreprocessConfigBuilder clearSourcePaths() {
            if (this.sourcePaths$key != null) {
                this.sourcePaths$key.clear();
                this.sourcePaths$value.clear();
            }
            return this;
        }

        public PreprocessConfigBuilder signedJarHandlingStrategy(SignedJarHandlingStrategy signedJarHandlingStrategy) {
            this.signedJarHandlingStrategy = signedJarHandlingStrategy;
            return this;
        }

        public PreprocessConfigBuilder subPreprocessors(String subPreprocessors) {
            this.subPreprocessors = subPreprocessors;
            return this;
        }

        public PreprocessConfigBuilder outputDir(String outputDir) {
            this.outputDir = outputDir;
            return this;
        }

        public PreprocessConfigBuilder agentPath(String agentPath) {
            this.agentPath = agentPath;
            return this;
        }

        public PreprocessConfigBuilder suffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public PreprocessConfigBuilder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public PreprocessConfigBuilder javaVersion(String javaVersion) {
            this.javaVersion = javaVersion;
            return this;
        }

        public PreprocessConfigBuilder agentArg(String agentArg) {
            this.agentArg = agentArg;
            return this;
        }

        public PreprocessConfigBuilder failOnUnresolvableDependency(boolean failOnUnresolvableDependency) {
            this.failOnUnresolvableDependency = failOnUnresolvableDependency;
            return this;
        }

        public PreprocessConfigBuilder jdkPath(String jdkPath) {
            this.jdkPath = jdkPath;
            return this;
        }

        public PreprocessConfigBuilder cacheStrategy(CacheStrategy cacheStrategy) {
            this.cacheStrategy = cacheStrategy;
            return this;
        }

        public PreprocessConfig build() {
            Map<Object, Object> sourcePaths;
            switch (this.sourcePaths$key == null ? 0 : this.sourcePaths$key.size()) {
                case 0: {
                    sourcePaths = Collections.emptyMap();
                    break;
                }
                case 1: {
                    sourcePaths = Collections.singletonMap(this.sourcePaths$key.get(0), this.sourcePaths$value.get(0));
                    break;
                }
                default: {
                    sourcePaths = new LinkedHashMap(this.sourcePaths$key.size() < 0x40000000 ? 1 + this.sourcePaths$key.size() + (this.sourcePaths$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.sourcePaths$key.size(); ++$i) {
                        sourcePaths.put(this.sourcePaths$key.get($i), this.sourcePaths$value.get($i));
                    }
                    sourcePaths = Collections.unmodifiableMap(sourcePaths);
                }
            }
            return new PreprocessConfig(sourcePaths, this.signedJarHandlingStrategy, this.subPreprocessors, this.outputDir, this.agentPath, this.suffix, this.logLevel, this.javaVersion, this.agentArg, this.failOnUnresolvableDependency, this.jdkPath, this.cacheStrategy);
        }

        public String toString() {
            return "PreprocessConfig.PreprocessConfigBuilder(sourcePaths$key=" + this.sourcePaths$key + ", sourcePaths$value=" + this.sourcePaths$value + ", signedJarHandlingStrategy=" + this.signedJarHandlingStrategy + ", subPreprocessors=" + this.subPreprocessors + ", outputDir=" + this.outputDir + ", agentPath=" + this.agentPath + ", suffix=" + this.suffix + ", logLevel=" + (Object)((Object)this.logLevel) + ", javaVersion=" + this.javaVersion + ", agentArg=" + this.agentArg + ", failOnUnresolvableDependency=" + this.failOnUnresolvableDependency + ", jdkPath=" + this.jdkPath + ", cacheStrategy=" + this.cacheStrategy + ")";
        }
    }
}

