/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.cli;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfigParser;
import software.amazon.disco.instrumentation.preprocess.exceptions.PreprocessCacheException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.CacheStrategy;
import software.amazon.disco.instrumentation.preprocess.instrumentation.cache.NoOpCacheStrategy;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JDKModuleLoader;
import software.amazon.disco.instrumentation.preprocess.multipreprocessor.MultiPreprocessorScheduler;
import software.amazon.disco.instrumentation.preprocess.util.PreprocessLoggerFactory;

public class Driver {
    private static final Logger log = LogManager.getLogger(Driver.class);

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("--help")) {
            Driver.printHelpText();
            System.exit(0);
        }
        try {
            PreprocessConfig config = new PreprocessConfigParser().parseCommandLine(args);
            Driver.configureLog(config.getLogLevel());
            CacheStrategy cacheStrategy = config.getCacheStrategy();
            cacheStrategy.loadManifestFileToRuntimeCache(config);
            Driver.removeCachedInputSourcesForProcessing(config);
            MultiPreprocessorScheduler.builder().config(config).build().execute();
            cacheStrategy.mergeTempCacheManifests(new File(config.getOutputDir()));
        }
        catch (Throwable e) {
            if (LogManager.isDefaultLoggerFactoryInstalled()) {
                System.err.println("Disco(Instrumentation preprocess) - Preprocessing aborted: " + e.getMessage());
            } else {
                log.fatal("Disco(Instrumentation preprocess) - Preprocessing aborted", e);
            }
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected static void printHelpText() {
        System.out.println("Disco Instrumentation Preprocess Library Command Line Interface\n\t Usage: [options] \n\t\t --help                              List all supported options supported by the CLI.\n\t\t @                                   <Path to a response file containing args to be supplied to the Preprocess tool. Cannot be used in combination with other args>\n\t\t --outputDir | -out                  <Root output directory where the transformed packages will be stored.>\n\t\t --sourcePaths | -sps                <List of paths to be instrumented delimited by ':'. An optional relative output path can be specified by appending '@' followed by the path. E.g. SomeJar.jar:AnotherJar.jar@lib>\n\t\t --agentPath | -ap                   <Path to the Disco Agent that will be applied to the packages supplied>\n\t\t --agentArg | -arg                   <Arguments that will be passed to the agent>\n\t\t --cachingStrategy | -cache          <Strategy used to cache already processed Jars. Options are [checksum, none]>\n\t\t --suffix | -suf                     <Suffix to be appended to the transformed packages>\n\t\t --javaVersion | -jv                 <Version of java to compile the transformed classes>\n\t\t --jdkSupport | -jdks                <Path to the JDK runtime to be instrumented. rt.jar for JDK 8, java.base.jmod for JDK 9 and higher>\n\t\t --failOnUnresolvableDependency      Abort the Static Instrumentation process completely if flag is present, log exception as warning otherwise\n\t\t --signedJarHandlingStrategy         <Strategy used to handle signed Jars. Options are [instrument, skip]>\n\t\t --verbose                           Set the log level to log everything.\n\t\t --silent                            Disable logging to the console.\n\nThe default behavior of the library will replace the original Jar (non-jdk) scheduled for instrumentation if NO outputDir AND suffix are supplied.\nTo avoid polluting the jdk lib directories, the output file will be stored under the directory where the tool is executed if no output dir is specified\n");
    }

    public static void configureLog(Logger.Level level) {
        LogManager.setMinimumLevel(level);
        LogManager.installLoggerFactory(new PreprocessLoggerFactory());
    }

    public static void removeCachedInputSourcesForProcessing(PreprocessConfig config) throws PreprocessCacheException {
        JDKModuleLoader jdkModuleLoader;
        CacheStrategy strategy = config.getCacheStrategy();
        if (strategy instanceof NoOpCacheStrategy) {
            return;
        }
        for (Set<String> dependenciesUnderSameRelativePath : config.getSourcePaths().values()) {
            Iterator<String> sourcesIterator = dependenciesUnderSameRelativePath.iterator();
            String src = null;
            while (sourcesIterator.hasNext()) {
                try {
                    src = sourcesIterator.next();
                    Path pathToSrc = Paths.get(src, new String[0]);
                    if (strategy.isSourceCached(pathToSrc)) {
                        log.trace("Disco(Instrumentation preprocess) - Dependency cached, skipping: " + pathToSrc);
                        sourcesIterator.remove();
                        continue;
                    }
                    log.trace("Disco(Instrumentation preprocess) - Dependency not cached: " + pathToSrc);
                }
                catch (Exception e) {
                    String errorMsg = String.format("%s Failed to verify if source [%s] was cached.", "Disco(Instrumentation preprocess) - ", src);
                    log.error(errorMsg, e);
                }
            }
        }
        if (config.getJdkPath() != null && strategy.isSourceCached((jdkModuleLoader = new JDKModuleLoader()).getJDKBaseModule(config.getJdkPath()).toPath())) {
            log.debug("Disco(Instrumentation preprocess) - JDK cached, skipping: " + config.getJdkPath());
            config.setJdkPath(null);
        }
    }
}

