/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;
import software.amazon.disco.agent.concurrent.decorate.DecoratedScheduledFutureTask;
import software.amazon.disco.agent.interception.InstallationError;
import software.amazon.disco.agent.interception.OneShotInstallable;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.asm.Advice;
import software.amazon.disco.agent.jar.bytebuddy.description.method.MethodDescription;
import software.amazon.disco.agent.jar.bytebuddy.description.modifier.Visibility;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.implementation.FieldAccessor;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ScheduledFutureTaskInterceptor
implements OneShotInstallable {
    private static final String TARGET_CLASS_FQN = "java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask";
    private static final Logger log = LogManager.getLogger(ScheduledFutureTaskInterceptor.class);

    ScheduledFutureTaskInterceptor() {
    }

    static Class<?> getTargetClass() throws ReflectiveOperationException {
        return Class.forName(TARGET_CLASS_FQN);
    }

    static ElementMatcher.Junction<? super TypeDescription> createScheduledFutureTaskTypeMatcher() {
        return ElementMatchers.named(TARGET_CLASS_FQN);
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunMethodMatcher() {
        return ElementMatchers.named("run").and(ElementMatchers.takesArguments(0));
    }

    @Override
    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ScheduledFutureTaskInterceptor.createScheduledFutureTaskTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.implement(new Type[]{DecoratedScheduledFutureTask.Accessor.class}).defineField("$discoDecoration", (Type)((Object)DecoratedScheduledFutureTask.class), 4).defineMethod("getDiscoDecoration", (Type)((Object)DecoratedScheduledFutureTask.class), Visibility.PUBLIC).intercept(FieldAccessor.ofField("$discoDecoration")).defineMethod("setDiscoDecoration", Void.TYPE, Visibility.PUBLIC).withParameter((Type)((Object)DecoratedScheduledFutureTask.class)).intercept(FieldAccessor.ofField("$discoDecoration")).visit(Advice.to(ConstructorAdvice.class).on(ElementMatchers.isConstructor())).visit(Advice.to(RunAdvice.class).on(ScheduledFutureTaskInterceptor.createRunMethodMatcher())));
    }

    @Override
    public void beforeDisposal() {
        Class<?> clazz = null;
        try {
            clazz = ScheduledFutureTaskInterceptor.getTargetClass();
        }
        catch (ReflectiveOperationException e) {
            log.error("DiSCo(Concurrency) failed to resolve ScheduledFutureTask class");
        }
        if (clazz != null) {
            OneShotInstallable.forceClassLoad(clazz);
        }
    }

    @Override
    public List<InstallationError> verifyEffect() {
        LinkedList<InstallationError> errors = new LinkedList<InstallationError>();
        try {
            ScheduledFutureTaskInterceptor.getTargetClass().getDeclaredField("$discoDecoration");
        }
        catch (ReflectiveOperationException e) {
            errors.add(new InstallationError("DiSCo(Concurrency) failed to instrument class java.util.concurrent.ScheduledThreadPoolExecutor$ScheduledFutureTask"));
        }
        return errors;
    }

    public static class RunAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            RunAdvice.methodEnter(thiz);
        }

        @Advice.OnMethodExit
        public static void onMethodExit(@Advice.This Object thiz) {
            RunAdvice.methodExit(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.getDiscoDecoration().before();
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ScheduledFutureTask", e);
            }
        }

        public static void methodExit(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.getDiscoDecoration().after();
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ScheduledFutureTask", e);
            }
        }
    }

    public static class ConstructorAdvice {
        @Advice.OnMethodExit
        public static void onMethodExit(@Advice.This Object thiz) {
            ConstructorAdvice.methodExit(thiz);
        }

        public static void methodExit(Object task) {
            try {
                DecoratedScheduledFutureTask.Accessor accessor = (DecoratedScheduledFutureTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedScheduledFutureTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to capture context in ScheduledFutureTask", e);
            }
        }
    }
}

