/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent;

import java.lang.instrument.Instrumentation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Supplier;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.concurrent.preprocess.DiscoRunnableDecorator;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.config.AgentConfigParser;
import software.amazon.disco.agent.interception.EffectVerificationStrategy;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.InterceptionInstaller;
import software.amazon.disco.agent.jar.bytebuddy.description.type.TypeDescription;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatcher;
import software.amazon.disco.agent.jar.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;
import software.amazon.disco.agent.logging.LoggerFactory;
import software.amazon.disco.agent.plugin.PluginDiscovery;
import software.amazon.disco.agent.plugin.PluginOutcome;

public class DiscoAgentTemplate {
    public static final String CORE_PSEUDO_PLUGIN_NAME = "(Core)";
    private static final Logger log = LogManager.getLogger(DiscoAgentTemplate.class);
    private static Supplier<AgentConfig> agentConfigFactory = null;
    private static EffectVerificationStrategy effectVerificationStrategy = EffectVerificationStrategy.Standard.DELEGATE_TO_PLUGINS;
    protected final AgentConfig config;
    private InterceptionInstaller interceptionInstaller = InterceptionInstaller.getInstance();
    private ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher = ElementMatchers.none();
    private boolean allowPlugins = true;

    public DiscoAgentTemplate(String agentArgs) {
        this.config = agentConfigFactory == null ? new AgentConfigParser().parseCommandLine(agentArgs) : agentConfigFactory.get();
        if (this.config.getLoggerFactoryClass() != null) {
            try {
                LoggerFactory loggerFactory = (LoggerFactory)LoggerFactory.class.cast(Class.forName(this.config.getLoggerFactoryClass(), true, ClassLoader.getSystemClassLoader()).newInstance());
                LogManager.installLoggerFactory(loggerFactory);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        log.info("DiSCo(Core) finished parsing argument list: " + agentArgs);
        if (this.config.isExtraverbose()) {
            LogManager.setMinimumLevel(Logger.Level.TRACE);
        } else if (this.config.isVerbose()) {
            LogManager.setMinimumLevel(Logger.Level.DEBUG);
        }
    }

    public void setAllowPlugins(boolean allowPlugins) {
        this.allowPlugins = allowPlugins;
    }

    public void setCustomIgnoreMatcher(ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        this.customIgnoreMatcher = customIgnoreMatcher;
    }

    public Collection<PluginOutcome> install(Instrumentation instrumentation, Set<Installable> installables) {
        return this.install(instrumentation, installables, ElementMatchers.none());
    }

    public Collection<PluginOutcome> install(Instrumentation instrumentation, Set<Installable> installables, ElementMatcher.Junction<? super TypeDescription> customIgnoreMatcher) {
        if (this.config.isRuntimeOnly()) {
            log.info("DiSCo(Core) setting agent as runtime-only. Ignoring all Installables, including those in Plugins.");
            installables.clear();
        }
        LinkedHashSet<Installable> allInstallables = new LinkedHashSet<Installable>(installables);
        if (this.allowPlugins) {
            PluginDiscovery.scan(instrumentation, this.config);
            allInstallables.addAll(PluginDiscovery.processInstallables());
        } else if (this.config.getPluginPath() != null) {
            log.warn("DiSCo(Core) plugin path set but agent is disallowing plugins. No plugins will be loaded");
        }
        for (Installable installable : allInstallables) {
            log.info("DiSCo(Core) passing arguments to " + installable.getClass().getSimpleName() + " to process");
            installable.handleArguments(this.config.getArgs());
        }
        this.interceptionInstaller.install(instrumentation, allInstallables, this.config, customIgnoreMatcher);
        DiscoRunnableDecorator.setDecorateFunction(new DecoratedRunnable.RunnableDecorateFunction());
        PluginOutcome builtinOutcome = new PluginOutcome(CORE_PSEUDO_PLUGIN_NAME);
        builtinOutcome.installables.addAll(installables);
        LinkedList<PluginOutcome> pluginOutcomes = new LinkedList<PluginOutcome>();
        pluginOutcomes.add(builtinOutcome);
        if (this.allowPlugins) {
            pluginOutcomes.addAll(PluginDiscovery.apply());
        }
        effectVerificationStrategy.verify(pluginOutcomes);
        return pluginOutcomes;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    InterceptionInstaller setInterceptionInstaller(InterceptionInstaller interceptionInstaller) {
        InterceptionInstaller old = this.interceptionInstaller;
        this.interceptionInstaller = interceptionInstaller;
        return old;
    }

    public static void setAgentConfigFactory(Supplier<AgentConfig> factory) {
        agentConfigFactory = factory;
    }

    public static Supplier<AgentConfig> getAgentConfigFactory() {
        return agentConfigFactory;
    }

    public static void setEffectVerificationStrategy(EffectVerificationStrategy strategy) {
        effectVerificationStrategy = strategy;
    }
}

