/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.loaders.agents;

import java.lang.instrument.Instrumentation;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.amazon.disco.agent.DiscoAgentTemplate;
import software.amazon.disco.agent.config.AgentConfig;
import software.amazon.disco.agent.config.AgentConfigParser;
import software.amazon.disco.agent.inject.Injector;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.jar.bytebuddy.ByteBuddy;
import software.amazon.disco.agent.jar.bytebuddy.ClassFileVersion;
import software.amazon.disco.agent.jar.bytebuddy.agent.builder.AgentBuilder;
import software.amazon.disco.agent.jar.bytebuddy.pool.TypePool;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.InvalidConfigEntryException;
import software.amazon.disco.instrumentation.preprocess.exceptions.NoAgentToLoadException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.TransformationListener;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.AgentLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.TransformerExtractor;

public class DiscoAgentLoader
implements AgentLoader {
    private static final Logger log = LogManager.getLogger(DiscoAgentLoader.class);

    @Override
    public void loadAgent(PreprocessConfig config, Instrumentation instrumentation) {
        if (config == null || config.getAgentPath() == null) {
            throw new NoAgentToLoadException();
        }
        ClassFileVersion version = DiscoAgentLoader.parseClassFileVersionFromConfig(config);
        DiscoAgentTemplate.setAgentConfigFactory(() -> {
            AgentConfig coreConfig = new AgentConfigParser().parseCommandLine(config.getAgentArg());
            coreConfig.setAgentBuilderTransformer(this.getAgentBuilderTransformer(version));
            return coreConfig;
        });
        Injector.loadAgent(instrumentation, config.getAgentPath(), null);
        log.info("Disco(Instrumentation preprocess) - " + TransformerExtractor.getTransformers().size() + " Installables loaded.");
    }

    private static String uuidGenerate(Installable installable) {
        return "mock uuid";
    }

    protected static ClassFileVersion parseClassFileVersionFromConfig(PreprocessConfig config) {
        try {
            if (config.getJavaVersion() == null) {
                log.info("Disco(Instrumentation preprocess) - Java version to compile transformed classes not specified, set to Java 8 by default");
                return ClassFileVersion.ofJavaVersion((int)8);
            }
            return ClassFileVersion.ofJavaVersion((int)Integer.parseInt(config.getJavaVersion()));
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigEntryException("java version: " + config.getJavaVersion(), e);
        }
    }

    private BiFunction<AgentBuilder, Installable, AgentBuilder> getAgentBuilderTransformer(ClassFileVersion version) {
        ConcurrentHashMap<ClassLoader, TypePool.CacheProvider.Simple> typePoolCache = new ConcurrentHashMap<ClassLoader, TypePool.CacheProvider.Simple>();
        typePoolCache.put(this.getClass().getClassLoader(), new TypePool.CacheProvider.Simple());
        return (agentBuilder, installable) -> agentBuilder.with(new ByteBuddy(version)).with((AgentBuilder.Listener)new TransformationListener(DiscoAgentLoader.uuidGenerate(installable))).with((AgentBuilder.PoolStrategy)new AgentBuilder.PoolStrategy.WithTypePoolCache.Simple(typePoolCache)).with((AgentBuilder.InitializationStrategy)AgentBuilder.InitializationStrategy.NoOp.INSTANCE);
    }
}

