/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.instrumentation.preprocess.instrumentation;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;
import software.amazon.disco.agent.inject.Injector;
import software.amazon.disco.instrumentation.preprocess.cli.PreprocessConfig;
import software.amazon.disco.instrumentation.preprocess.exceptions.AgentLoaderNotProvidedException;
import software.amazon.disco.instrumentation.preprocess.exceptions.InstrumentationException;
import software.amazon.disco.instrumentation.preprocess.exceptions.InvalidConfigEntryException;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationOutcome;
import software.amazon.disco.instrumentation.preprocess.instrumentation.InstrumentationTask;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.AgentLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.agents.TransformerExtractor;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.ClassFileLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.DirectoryLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JDKModuleLoader;
import software.amazon.disco.instrumentation.preprocess.loaders.classfiles.JarLoader;

public class StaticInstrumentationTransformer {
    public static final String INSTRUMENTED_JDK_RELATIVE_PATH = "jdk";
    private static final Logger log = LogManager.getLogger(StaticInstrumentationTransformer.class);
    private final PreprocessConfig config;
    private final List<InstrumentationOutcome> sourcesFailedToBeInstrumented = new ArrayList<InstrumentationOutcome>();
    private final List<InstrumentationOutcome> sourcesInstrumented = new ArrayList<InstrumentationOutcome>();
    private final AgentLoader agentLoader;
    private final Map<Class<? extends ClassFileLoader>, ClassFileLoader> classFileLoaders;
    private final List<InstrumentationOutcome> allOutcomes = new ArrayList<InstrumentationOutcome>();

    public void transform() {
        log.info("Initiating build time instrumentation...");
        if (this.config == null) {
            throw new InvalidConfigEntryException("No configuration provided", null);
        }
        Configurator.setRootLevel(this.config.getLogLevel());
        if (this.agentLoader == null) {
            throw new AgentLoaderNotProvidedException();
        }
        this.agentLoader.loadAgent(this.config, new TransformerExtractor(Injector.createInstrumentation()));
        this.processAllSources();
        this.logInstrumentationSummary();
    }

    protected void processAllSources() {
        ArrayList<InstrumentationTask> tasks = new ArrayList<InstrumentationTask>();
        for (Map.Entry<String, Set<String>> entry : this.config.getSourcePaths().entrySet()) {
            for (String source : entry.getValue()) {
                try {
                    Class loaderType;
                    Path pathToSrc = Paths.get(source, new String[0]);
                    Path actualPathToSrc = Files.isSymbolicLink(pathToSrc) ? Files.readSymbolicLink(pathToSrc) : pathToSrc;
                    Class clazz = loaderType = actualPathToSrc.toFile().isFile() ? JarLoader.class : DirectoryLoader.class;
                    if (this.classFileLoaders.get(loaderType) != null) {
                        tasks.add(new InstrumentationTask(this.classFileLoaders.get(loaderType), actualPathToSrc, this.config, entry.getKey()));
                        continue;
                    }
                    throw new InstrumentationException("Loader not provided: " + loaderType.getName());
                }
                catch (Exception e) {
                    throw new InstrumentationException("Failed to configure loader for source: " + source, e);
                }
            }
        }
        if (this.config.getJdkPath() != null) {
            tasks.add(new InstrumentationTask(new JDKModuleLoader(), Paths.get(this.config.getJdkPath(), new String[0]), this.config, INSTRUMENTED_JDK_RELATIVE_PATH));
        }
        for (InstrumentationTask task : tasks) {
            InstrumentationOutcome outcome = task.applyInstrumentation();
            this.allOutcomes.add(outcome);
            if (outcome.getStatus().equals((Object)InstrumentationOutcome.Status.NO_OP)) continue;
            if (outcome.hasFailed()) {
                this.sourcesFailedToBeInstrumented.add(outcome);
                continue;
            }
            this.sourcesInstrumented.add(outcome);
        }
    }

    protected void logInstrumentationSummary() {
        boolean isVerbose = log.getLevel().isLessSpecificThan(Level.DEBUG);
        log.info("Disco(Instrumentation preprocess) - Build-Time Instrumentation summary:");
        log.info("Disco(Instrumentation preprocess) - Sources processed: " + this.allOutcomes.size());
        log.info("Disco(Instrumentation preprocess) - Sources instrumented: " + this.sourcesInstrumented.size());
        if (isVerbose) {
            for (InstrumentationOutcome outcome : this.sourcesInstrumented) {
                log.debug("\t+ Disco(Instrumentation preprocess) - " + outcome.getSource());
            }
        }
        log.info("Disco(Instrumentation preprocess) - Sources containing classes with unresolvable dependencies: " + this.sourcesFailedToBeInstrumented.size());
        for (InstrumentationOutcome outcome : this.sourcesFailedToBeInstrumented) {
            log.debug("Disco(Instrumentation preprocess) - " + outcome.getSource());
            if (!isVerbose) continue;
            outcome.getFailedClasses().forEach(clazz -> log.debug("Disco(Instrumentation preprocess) - \t+ " + clazz));
        }
    }

    public static StaticInstrumentationTransformerBuilder builder() {
        return new StaticInstrumentationTransformerBuilder();
    }

    public StaticInstrumentationTransformer(PreprocessConfig config, AgentLoader agentLoader, Map<Class<? extends ClassFileLoader>, ClassFileLoader> classFileLoaders) {
        this.config = config;
        this.agentLoader = agentLoader;
        this.classFileLoaders = classFileLoaders;
    }

    public List<InstrumentationOutcome> getAllOutcomes() {
        return this.allOutcomes;
    }

    public static class StaticInstrumentationTransformerBuilder {
        private PreprocessConfig config;
        private AgentLoader agentLoader;
        private ArrayList<Class<? extends ClassFileLoader>> classFileLoaders$key;
        private ArrayList<ClassFileLoader> classFileLoaders$value;

        StaticInstrumentationTransformerBuilder() {
        }

        public StaticInstrumentationTransformerBuilder config(PreprocessConfig config) {
            this.config = config;
            return this;
        }

        public StaticInstrumentationTransformerBuilder agentLoader(AgentLoader agentLoader) {
            this.agentLoader = agentLoader;
            return this;
        }

        public StaticInstrumentationTransformerBuilder classFileLoader(Class<? extends ClassFileLoader> classFileLoaderKey, ClassFileLoader classFileLoaderValue) {
            if (this.classFileLoaders$key == null) {
                this.classFileLoaders$key = new ArrayList();
                this.classFileLoaders$value = new ArrayList();
            }
            this.classFileLoaders$key.add(classFileLoaderKey);
            this.classFileLoaders$value.add(classFileLoaderValue);
            return this;
        }

        public StaticInstrumentationTransformerBuilder classFileLoaders(Map<? extends Class<? extends ClassFileLoader>, ? extends ClassFileLoader> classFileLoaders) {
            if (classFileLoaders == null) {
                throw new NullPointerException("classFileLoaders cannot be null");
            }
            if (this.classFileLoaders$key == null) {
                this.classFileLoaders$key = new ArrayList();
                this.classFileLoaders$value = new ArrayList();
            }
            for (Map.Entry<? extends Class<? extends ClassFileLoader>, ? extends ClassFileLoader> $lombokEntry : classFileLoaders.entrySet()) {
                this.classFileLoaders$key.add($lombokEntry.getKey());
                this.classFileLoaders$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public StaticInstrumentationTransformerBuilder clearClassFileLoaders() {
            if (this.classFileLoaders$key != null) {
                this.classFileLoaders$key.clear();
                this.classFileLoaders$value.clear();
            }
            return this;
        }

        public StaticInstrumentationTransformer build() {
            Map<Class<? extends ClassFileLoader>, ClassFileLoader> classFileLoaders;
            switch (this.classFileLoaders$key == null ? 0 : this.classFileLoaders$key.size()) {
                case 0: {
                    classFileLoaders = Collections.emptyMap();
                    break;
                }
                case 1: {
                    classFileLoaders = Collections.singletonMap(this.classFileLoaders$key.get(0), this.classFileLoaders$value.get(0));
                    break;
                }
                default: {
                    classFileLoaders = new LinkedHashMap(this.classFileLoaders$key.size() < 0x40000000 ? 1 + this.classFileLoaders$key.size() + (this.classFileLoaders$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.classFileLoaders$key.size(); ++$i) {
                        classFileLoaders.put(this.classFileLoaders$key.get($i), this.classFileLoaders$value.get($i));
                    }
                    classFileLoaders = Collections.unmodifiableMap(classFileLoaders);
                }
            }
            return new StaticInstrumentationTransformer(this.config, this.agentLoader, classFileLoaders);
        }

        public String toString() {
            return "StaticInstrumentationTransformer.StaticInstrumentationTransformerBuilder(config=" + this.config + ", agentLoader=" + this.agentLoader + ", classFileLoaders$key=" + this.classFileLoaders$key + ", classFileLoaders$value=" + this.classFileLoaders$value + ")";
        }
    }
}

