/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.plugin;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.loading.ClassInjector;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ResourcesClassInjector {
    private static final Logger log = LogManager.getLogger(ResourcesClassInjector.class);
    private static Map<String, byte[]> injectedDependencies = new HashMap<String, byte[]>();

    public static void injectClass(ClassLoader targetClassLoader, ClassLoader sourceClassloader, String className) {
        try {
            byte[] bytes = ClassFileLocator.ForClassLoader.of((ClassLoader)sourceClassloader).locate("resources." + className).resolve();
            injectedDependencies.put(className.replace('.', '/'), bytes);
            if (!ResourcesClassInjector.classExistsIn(className, targetClassLoader)) {
                new ClassInjector.UsingUnsafe(targetClassLoader).injectRaw(Collections.singletonMap(className, bytes));
            }
        }
        catch (Throwable t) {
            String errorMessage = String.format("Disco(Core) could not inject class: %s in classloader: %s", className == null ? "null class" : className, targetClassLoader == null ? "null classloader" : targetClassLoader.toString());
            log.error(errorMessage, t);
        }
    }

    public static void injectAllClasses(ClassLoader targetClassLoader, ClassLoader sourceClassloader, String ... classNames) {
        if (classNames != null) {
            for (String className : classNames) {
                ResourcesClassInjector.injectClass(targetClassLoader, sourceClassloader, className);
            }
        }
    }

    public static boolean classExistsIn(String className, ClassLoader classLoader) {
        try {
            Class.forName(className, false, classLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Map<String, byte[]> getInjectedDependencies() {
        return injectedDependencies;
    }
}

