/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.lang.reflect.Type;
import java.util.concurrent.ForkJoinTask;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.interception.OneShotInstallable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinTaskInterceptor
implements OneShotInstallable {
    public static Logger log = LogManager.getLogger(ForkJoinTaskInterceptor.class);

    ForkJoinTaskInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ForkJoinTaskInterceptor.createForkJoinTaskTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.implement(new Type[]{DecoratedForkJoinTask.Accessor.class}).defineField("$discoDecoration", DecoratedForkJoinTask.class, 4).defineMethod("getDiscoDecoration", DecoratedForkJoinTask.class, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).defineMethod("setDiscoDecoration", Void.TYPE, new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).withParameter(DecoratedForkJoinTask.class).intercept((Implementation)FieldAccessor.ofField((String)"$discoDecoration")).method(ForkJoinTaskInterceptor.createForkMethodMatcher()).intercept((Implementation)Advice.to(ForkAdvice.class)));
    }

    @Override
    public void beforeDisposal() {
        OneShotInstallable.forceClassLoad(ForkJoinTask.class);
    }

    static ElementMatcher.Junction<? super TypeDescription> createForkJoinTaskTypeMatcher() {
        return ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask");
    }

    static ElementMatcher.Junction<? super MethodDescription> createForkMethodMatcher() {
        return ElementMatchers.named((String)"fork").and((ElementMatcher)ElementMatchers.takesArguments((int)0));
    }

    public static class ForkAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            ForkAdvice.methodEnter(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedForkJoinTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ForkJoinTask", (Throwable)e);
            }
        }
    }
}

