/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.ForkJoinPool;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedCallable;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.OneShotInstallable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinPoolInterceptor
implements OneShotInstallable {
    public static Logger log = LogManager.getLogger(ForkJoinPoolInterceptor.class);

    ForkJoinPoolInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.ignore((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinPool"))).type(ForkJoinPoolInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(ForkJoinPoolInterceptor.createRunnableMethodsMatcher()).intercept((Implementation)Advice.to(RunnableMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createCallableMethodsMatcher()).intercept((Implementation)Advice.to(CallableMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createCallableCollectionMethodsMatcher()).intercept((Implementation)Advice.to(CallableCollectionMethodsAdvice.class)).method(ForkJoinPoolInterceptor.createForkJoinTaskMethodsMatcher()).intercept((Implementation)Advice.to(ForkJoinTaskMethodsAdvice.class)));
    }

    @Override
    public void beforeDisposal() {
        OneShotInstallable.forceClassLoad(ForkJoinPool.class);
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.named((String)"java.util.concurrent.ForkJoinPool");
    }

    static ElementMatcher.Junction<? super MethodDescription> createRunnableMethodsMatcher() {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.named((String)"execute").or((ElementMatcher)ElementMatchers.named((String)"submit"))).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Runnable.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createCallableMethodsMatcher() {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.named((String)"submit")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Callable.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createCallableCollectionMethodsMatcher() {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.named((String)"invokeAll")).and((ElementMatcher)ElementMatchers.takesArgument((int)0, Collection.class));
    }

    static ElementMatcher.Junction<? super MethodDescription> createForkJoinTaskMethodsMatcher() {
        return ElementMatchers.isPublic().and((ElementMatcher)ElementMatchers.named((String)"invoke").or((ElementMatcher)ElementMatchers.named((String)"execute")).or((ElementMatcher)ElementMatchers.named((String)"submit"))).and((ElementMatcher)ElementMatchers.takesArgument((int)0, (ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask")));
    }

    public static class ForkJoinTaskMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, typing=Assigner.Typing.DYNAMIC) Object task) {
            ForkJoinTaskMethodsAdvice.methodEnter(task);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                accessor.setDiscoDecoration(DecoratedForkJoinTask.create());
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) could not propagate context into " + task);
            }
        }
    }

    public static class CallableCollectionMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Collection<Callable> tasks) {
            tasks = CallableCollectionMethodsAdvice.methodEnter(tasks);
        }

        public static Collection<Callable> methodEnter(Collection<Callable> tasks) {
            int size = tasks.size();
            if (size > 0) {
                ArrayList<Callable> decorated = new ArrayList<Callable>(size);
                for (Callable c : tasks) {
                    decorated.add(DecoratedCallable.maybeCreate(c));
                }
                return decorated;
            }
            return tasks;
        }
    }

    public static class CallableMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Callable task) {
            task = CallableMethodsAdvice.methodEnter(task);
        }

        public static Callable methodEnter(Callable task) {
            return DecoratedCallable.maybeCreate(task);
        }
    }

    public static class RunnableMethodsAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Runnable task) {
            task = RunnableMethodsAdvice.methodEnter(task);
        }

        public static Runnable methodEnter(Runnable task) {
            return DecoratedRunnable.maybeCreate(task);
        }
    }
}

