/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.ConcurrentMap;
import software.amazon.disco.agent.concurrent.MetadataItem;
import software.amazon.disco.agent.concurrent.TransactionContext;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.ThreadEnterEvent;
import software.amazon.disco.agent.event.ThreadExitEvent;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class ConcurrentUtils {
    private static Logger log = LogManager.getLogger(ConcurrentUtils.class);

    public static void enter(long parentThreadId, ConcurrentMap<String, MetadataItem> discoTransactionContext) {
        if (discoTransactionContext == null) {
            log.error("DiSCo(Core) could not propagate null context from parent thread id " + parentThreadId + " to thread id " + Thread.currentThread().getId());
            return;
        }
        if (!ConcurrentUtils.isDiscoNullId(discoTransactionContext)) {
            TransactionContext.setPrivateMetadata(discoTransactionContext);
            EventBus.publish((Event)new ThreadEnterEvent("Concurrency", Long.valueOf(parentThreadId), Long.valueOf(Thread.currentThread().getId())));
        }
    }

    public static void exit(long parentThreadId, ConcurrentMap<String, MetadataItem> discoTransactionContext, boolean removeTransactionContext) {
        if (discoTransactionContext == null) {
            return;
        }
        if (!ConcurrentUtils.isDiscoNullId(discoTransactionContext)) {
            EventBus.publish((Event)new ThreadExitEvent("Concurrency", Long.valueOf(parentThreadId), Long.valueOf(Thread.currentThread().getId())));
        }
        if (removeTransactionContext) {
            TransactionContext.remove();
        }
    }

    private static boolean isDiscoNullId(ConcurrentMap<String, MetadataItem> discoTransactionContext) {
        MetadataItem item = (MetadataItem)discoTransactionContext.get("$amazon.discoTransactionId");
        if (item == null) {
            return false;
        }
        return TransactionContext.getUninitializedTransactionContextValue().equals(item.get());
    }
}

