/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.decorate.DecoratedForkJoinTask;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ForkJoinTaskSubclassInterceptor
implements Installable {
    public static Logger log = LogManager.getLogger(ForkJoinTaskSubclassInterceptor.class);

    ForkJoinTaskSubclassInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(ForkJoinTaskSubclassInterceptor.createForkJoinTaskSubclassTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.method(ForkJoinTaskSubclassInterceptor.createExecMethodMatcher()).intercept((Implementation)Advice.to(ExecAdvice.class)));
    }

    static ElementMatcher.Junction<? super TypeDescription> createForkJoinTaskSubclassTypeMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask"));
    }

    static ElementMatcher.Junction<? super MethodDescription> createExecMethodMatcher() {
        return ElementMatchers.named((String)"exec").and((ElementMatcher)ElementMatchers.isOverriddenFrom((ElementMatcher)ElementMatchers.named((String)"java.util.concurrent.ForkJoinTask"))).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }

    public static class ExecAdvice {
        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.This Object thiz) {
            ExecAdvice.methodEnter(thiz);
        }

        public static void methodEnter(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                DecoratedForkJoinTask decorated = accessor.getDiscoDecoration();
                if (decorated != null) {
                    decorated.before();
                }
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ForkJoinTask", (Throwable)e);
            }
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit(@Advice.This Object thiz) {
            ExecAdvice.methodExit(thiz);
        }

        public static void methodExit(Object task) {
            try {
                DecoratedForkJoinTask.Accessor accessor = (DecoratedForkJoinTask.Accessor)task;
                DecoratedForkJoinTask decorated = accessor.getDiscoDecoration();
                if (decorated != null) {
                    decorated.after();
                }
            }
            catch (Exception e) {
                log.error("DiSCo(Concurrency) unable to propagate context in ForkJoinTask", (Throwable)e);
            }
        }
    }
}

