/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.concurrent.InterceptorUtils;
import software.amazon.disco.agent.concurrent.decorate.DecoratedRunnable;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.interception.MethodInterceptionCounter;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

class ExecutorInterceptor
implements Installable {
    private static Logger log = LogManager.getLogger(ExecutorInterceptor.class);

    ExecutorInterceptor() {
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return InterceptorUtils.configureRedefinition(agentBuilder).type(ExecutorInterceptor.createTypeMatcher()).transform((builder, typeDescription, classLoader, module) -> builder.visit((AsmVisitorWrapper)Advice.to(ExecuteAdvice.class).on(ExecutorInterceptor.createMethodMatcher())));
    }

    static ElementMatcher.Junction<? super TypeDescription> createTypeMatcher() {
        return ElementMatchers.isSubTypeOf(Executor.class).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isSubTypeOf(ScheduledThreadPoolExecutor.class)));
    }

    static ElementMatcher.Junction<? super MethodDescription> createMethodMatcher() {
        return ElementMatchers.named((String)"execute").and((ElementMatcher)ElementMatchers.isOverriddenFrom(Executor.class)).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }

    public static class ExecuteAdvice {
        public static final MethodInterceptionCounter interceptionCounter = new MethodInterceptionCounter();

        @Advice.OnMethodEnter
        public static void onMethodEnter(@Advice.Argument(value=0, readOnly=false) Runnable command) {
            try {
                command = ExecuteAdvice.methodEnter(command);
            }
            catch (Throwable t) {
                ExecuteAdvice.captureThrowableForDebugging(t);
            }
        }

        public static Runnable methodEnter(Runnable command) {
            boolean reentrant = interceptionCounter.hasIntercepted();
            interceptionCounter.increment();
            if (reentrant) {
                return command;
            }
            return DecoratedRunnable.maybeCreate(command);
        }

        @Advice.OnMethodExit(onThrowable=Throwable.class)
        public static void onMethodExit() {
            ExecuteAdvice.methodExit();
        }

        public static void methodExit() {
            interceptionCounter.decrement();
        }

        public static void captureThrowableForDebugging(Throwable t) {
            log.error("DiSCo(Concurrency) failed to decorate Runnable for Executor", t);
        }
    }
}

