/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.disco.agent.awsv1;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.disco.agent.event.AbstractServiceResponseEvent;
import software.amazon.disco.agent.event.AwsV1ServiceDownstreamRequestEventImpl;
import software.amazon.disco.agent.event.Event;
import software.amazon.disco.agent.event.EventBus;
import software.amazon.disco.agent.event.ServiceDownstreamRequestEvent;
import software.amazon.disco.agent.event.ServiceDownstreamResponseEvent;
import software.amazon.disco.agent.event.ServiceRequestEvent;
import software.amazon.disco.agent.interception.Installable;
import software.amazon.disco.agent.logging.LogManager;
import software.amazon.disco.agent.logging.Logger;

public class AWSClientInvokeInterceptor
implements Installable {
    public static final Logger log = LogManager.getLogger(AWSClientInvokeInterceptor.class);
    public static final String AWS_V1_ORIGIN = "AWSv1";

    @Advice.OnMethodEnter(suppress=Throwable.class)
    public static ServiceDownstreamRequestEvent enter(@Advice.Argument(value=0) Request<?> request, @Advice.Origin String origin) {
        if (LogManager.isDebugEnabled()) {
            log.debug("DiSCo(AWSv1) method interception of " + origin);
        }
        String service = request.getServiceName();
        AmazonWebServiceRequest originalRequest = request.getOriginalRequest();
        String operation = originalRequest.getClass().getSimpleName().replace("Request", "");
        AwsV1ServiceDownstreamRequestEventImpl requestEvent = new AwsV1ServiceDownstreamRequestEventImpl(AWS_V1_ORIGIN, service, operation);
        requestEvent.withRequest(request);
        EventBus.publish((Event)requestEvent);
        return requestEvent;
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class)
    public static void exit(@Advice.Enter ServiceDownstreamRequestEvent requestEvent, @Advice.Return Object response, @Advice.Thrown Throwable thrown) {
        AbstractServiceResponseEvent responseEvent = new ServiceDownstreamResponseEvent(AWS_V1_ORIGIN, requestEvent.getService(), requestEvent.getOperation(), (ServiceRequestEvent)requestEvent).withResponse(response).withThrown(thrown);
        EventBus.publish((Event)responseEvent);
    }

    public AgentBuilder install(AgentBuilder agentBuilder) {
        return agentBuilder.type(this.buildClassMatcher()).transform((AgentBuilder.Transformer)new AgentBuilder.Transformer.ForAdvice().include(new ClassLoader[]{this.getClass().getClassLoader()}).advice(this.buildMethodMatcher(), this.getClass().getName()));
    }

    ElementMatcher<? super TypeDescription> buildClassMatcher() {
        return ElementMatchers.hasSuperType((ElementMatcher)ElementMatchers.named((String)"com.amazonaws.AmazonWebServiceClient")).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isInterface())).and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }

    ElementMatcher<? super MethodDescription> buildMethodMatcher() {
        return ElementMatchers.named((String)"doInvoke").and((ElementMatcher)ElementMatchers.not((ElementMatcher)ElementMatchers.isAbstract()));
    }
}

