/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.com.amazon.cbor.Encoder;
import software.amazon.dax.com.amazon.cbor.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.DaxCborOutputStream;
import software.amazon.dax.com.amazon.dax.bits.SegmentPool;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.com.amazon.dax.client.dynamodb.DaxRequestEncoder;
import software.amazon.dax.dynamodb.AttributeValueEncoder;
import software.amazon.dax.dynamodb.DynamoDBExpressionInfo;
import software.amazon.dax.dynamodb.DynamoDBV1Converter;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.RequestValidator;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.expr.ExpressionValidationModel;

public class PutItemRequestEncoder
extends RequestEncoder<PutItemRequest> {
    private final SegmentPool segmentPool;
    private final RefreshingCache<String, List<AttributeDefinition>> keyCache;
    private final SimpleCache<List<String>, Long> attributeListIdCache;

    public PutItemRequestEncoder(SegmentPool segmentPool, RefreshingCache<String, List<AttributeDefinition>> keyCache, SimpleCache<List<String>, Long> attributeListIdCache) {
        this.segmentPool = segmentPool;
        this.keyCache = keyCache;
        this.attributeListIdCache = attributeListIdCache;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, PutItemRequest request, ChannelPromise promise) throws Exception {
        String tableName = request.tableName();
        RequestValidator.validateTableName(tableName);
        RequestValidator.validateExpression(new ExpressionValidationModel().conditionExpression(request.conditionExpression()).conditionalOperator(request.conditionalOperatorAsString()).expected(request.hasExpected() ? request.expected() : null).expressionAttributeNames(request.hasExpressionAttributeNames() ? request.expressionAttributeNames() : null).expressionAttributeValues(request.hasExpressionAttributeValues() ? request.expressionAttributeValues() : null));
        RequestValidator.validateTableNameString(tableName);
        this.keyCache.get(tableName).whenComplete((keys, e) -> {
            if (e != null) {
                promise.setFailure(e);
            } else {
                try {
                    this.encodeKeyValue(ctx, request, (List<AttributeDefinition>)keys, promise);
                }
                catch (Throwable t) {
                    promise.setFailure(t);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encodeKeyValue(ChannelHandlerContext ctx, PutItemRequest request, List<AttributeDefinition> keys, ChannelPromise promise) throws Exception {
        SegmentPool.Segment cborKey = this.segmentPool.alloc();
        SegmentPool.Segment cborValue = this.segmentPool.alloc();
        Map attributes = request.item();
        try {
            AttributeValueEncoder.encodeKey(this.segmentPool, cborKey, attributes, keys);
            byte[] cborKeyBytes = this.segmentPool.chainCopyAndTrim(cborKey, 0);
            AttributeValueEncoder.encodeAttributes((Map<String, AttributeValue>)request.item(), keys, this.attributeListIdCache, this.segmentPool, cborValue).whenComplete((offset, ex) -> {
                if (ex != null) {
                    this.segmentPool.recycle(cborValue);
                    promise.setFailure(ex);
                } else {
                    try {
                        byte[] cborValueBytes = this.segmentPool.chainCopyAndTrim(cborValue, (int)offset);
                        this.encodeAndWrite(ctx, request, cborKeyBytes, cborValueBytes, promise);
                    }
                    catch (Throwable t) {
                        promise.setFailure(t);
                    }
                    finally {
                        this.segmentPool.recycle(cborValue);
                    }
                }
            });
        }
        finally {
            this.segmentPool.recycle(cborKey);
        }
    }

    public void encodeAndWrite(ChannelHandlerContext ctx, PutItemRequest request, byte[] cborKeyBytes, byte[] cborValueBytes, ChannelPromise promise) throws IOException {
        DynamoDBExpressionInfo exp = null;
        exp = DynamoDBV1Converter.isV1Request(request) ? DynamoDBV1Converter.convertV1RequestToV2(request) : new DynamoDBExpressionInfo(request);
        DynamoNumerals.ReturnValue returnValue = DynamoNumerals.ReturnValue.fromName(request.returnValuesAsString());
        DynamoNumerals.ReturnConsumedCapacity returnConsumedCapacity = DynamoNumerals.ReturnConsumedCapacity.fromName(request.returnConsumedCapacityAsString());
        DynamoNumerals.ReturnItemCollectionMetrics returnItemCollectionMetrics = DynamoNumerals.ReturnItemCollectionMetrics.fromName(request.returnItemCollectionMetricsAsString());
        byte[] optional = DaxRequestEncoder.encodeItemOperationsOptionalParams(returnValue.mCode, returnConsumedCapacity.mCode, returnItemCollectionMetrics.mCode, AttributeValueEncoder.encodeConditionalExp(exp), null, null, this.segmentPool);
        ByteBuf buffer = ctx.alloc().buffer();
        try (DaxCborOutputStream out = new DaxCborOutputStream((OutputStream)new ByteBufOutputStream(buffer), 0);){
            out.writeInt(1);
            out.writeInt(-2106490455);
            out.writeBytes(Encoder.encodeUtf8(request.tableName()));
            out.writeBytes(cborKeyBytes);
            out.writeBytes(cborValueBytes);
            if (optional != null) {
                out.write(optional);
            } else {
                out.writeNull();
            }
            out.flush();
            ctx.writeAndFlush((Object)buffer, promise);
        }
    }
}

