/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.dax.bits.dynamodb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AttributeValue {
    public static final int TYPE_STRING = 1;
    public static final int TYPE_NUMBER = 2;
    public static final int TYPE_BINARY = 3;
    public static final int TYPE_STRING_SET = 4;
    public static final int TYPE_NUMBER_SET = 5;
    public static final int TYPE_BINARY_SET = 6;
    public static final int TYPE_MAP = 7;
    public static final int TYPE_LIST = 8;
    public static final int TYPE_NULL = 9;
    public static final int TYPE_BOOLEAN = 10;
    public static final AttributeValue NULL = new AttributeValue(9, null);
    public static final AttributeValue FALSE = new AttributeValue(10, false);
    public static final AttributeValue TRUE = new AttributeValue(10, true);
    public final int type;
    public final Object value;

    public static AttributeValue withString(String str) {
        if (str == null) {
            return NULL;
        }
        return new AttributeValue(1, str);
    }

    public static AttributeValue withNumber(Number num) {
        if (num == null) {
            return NULL;
        }
        return new AttributeValue(2, num.toString());
    }

    public static AttributeValue withBinary(byte[] bytes) {
        if (bytes == null) {
            return NULL;
        }
        return new AttributeValue(3, bytes);
    }

    public static AttributeValue withStringSet(String ... set) {
        if (set == null) {
            return NULL;
        }
        return new AttributeValue(4, Arrays.asList(set));
    }

    public static AttributeValue withNumberSet(Number ... set) {
        if (set == null) {
            return NULL;
        }
        ArrayList<String> list = new ArrayList<String>(set.length);
        for (Number num : set) {
            list.add(num == null ? null : num.toString());
        }
        return new AttributeValue(5, list);
    }

    public static AttributeValue withBinarySet(byte[] ... set) {
        if (set == null) {
            return NULL;
        }
        return new AttributeValue(6, Arrays.asList(set));
    }

    public static AttributeValue withMap(Map<String, AttributeValue> map) {
        if (map == null) {
            return NULL;
        }
        return new AttributeValue(7, map);
    }

    public static AttributeValue withList(List<AttributeValue> list) {
        if (list == null) {
            return NULL;
        }
        return new AttributeValue(8, list);
    }

    public static AttributeValue withList(AttributeValue ... list) {
        if (list == null) {
            return NULL;
        }
        return new AttributeValue(8, Arrays.asList(list));
    }

    public AttributeValue(int type, Object value) {
        this.type = type;
        this.value = value;
    }

    public int hashCode() {
        return this.type + Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AttributeValue) {
            AttributeValue other = (AttributeValue)obj;
            if (this.type == other.type) {
                if (this.type != 6) {
                    return Objects.deepEquals(this.value, other.value);
                }
                Collection c1 = (Collection)this.value;
                Collection c2 = (Collection)other.value;
                if (c1 == null) {
                    if (c2 == null) {
                        return true;
                    }
                } else {
                    if (c2 == null) {
                        return false;
                    }
                    if (c1.size() != c2.size()) {
                        return false;
                    }
                    Iterator i1 = c1.iterator();
                    Iterator i2 = c2.iterator();
                    while (i1.hasNext()) {
                        if (Objects.deepEquals(i1.next(), i2.next())) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        return this.getType() + ':' + this.value;
    }

    public String getType() {
        switch (this.type) {
            default: {
                return "?";
            }
            case 1: {
                return "S";
            }
            case 2: {
                return "N";
            }
            case 3: {
                return "B";
            }
            case 4: {
                return "SS";
            }
            case 5: {
                return "NS";
            }
            case 6: {
                return "BS";
            }
            case 7: {
                return "M";
            }
            case 8: {
                return "L";
            }
            case 9: {
                return "NULL";
            }
            case 10: 
        }
        return "BOOL";
    }
}

