/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.com.amazon.cbor;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.Buffer;

public class Utils {
    private static final MethodHandle cIntToUnsignedString;
    private static final MethodHandle cLongToUnsignedString;
    private static final MethodHandle cBigIntegerLongValueExact;
    private static volatile boolean cDeleteUnsupported;

    protected Utils() {
    }

    public static int compareUnsigned(byte[] a, byte[] b) {
        return Utils.compareUnsigned(a, 0, a.length, b, 0, b.length);
    }

    public static int compareUnsigned(byte[] a, int aoff, int alen, byte[] b, int boff, int blen) {
        int minLen = Math.min(alen, blen);
        for (int i = 0; i < minLen; ++i) {
            byte ab = a[aoff + i];
            byte bb = b[boff + i];
            if (ab == bb) continue;
            return (ab & 0xFF) - (bb & 0xFF);
        }
        return alen - blen;
    }

    public static boolean increment(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] + 1);
            if (value[n] == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean decrement(byte[] value, int start, int end) {
        while (--end >= start) {
            int n = end;
            value[n] = (byte)(value[n] - 1);
            if (value[n] == -1) continue;
            return true;
        }
        return false;
    }

    public static final void encodeShortBE(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 8);
        b[offset + 1] = (byte)v;
    }

    public static final void encodeShortLE(byte[] b, int offset, int v) {
        b[offset] = (byte)v;
        b[offset + 1] = (byte)(v >> 8);
    }

    public static final void encodeIntBE(byte[] b, int offset, int v) {
        b[offset] = (byte)(v >> 24);
        b[offset + 1] = (byte)(v >> 16);
        b[offset + 2] = (byte)(v >> 8);
        b[offset + 3] = (byte)v;
    }

    public static final void encodeIntLE(byte[] b, int offset, int v) {
        b[offset] = (byte)v;
        b[offset + 1] = (byte)(v >> 8);
        b[offset + 2] = (byte)(v >> 16);
        b[offset + 3] = (byte)(v >> 24);
    }

    public static final void encodeInt48BE(byte[] b, int offset, long v) {
        int w = (int)(v >> 32);
        b[offset] = (byte)(w >> 8);
        b[offset + 1] = (byte)w;
        w = (int)v;
        b[offset + 2] = (byte)(w >> 24);
        b[offset + 3] = (byte)(w >> 16);
        b[offset + 4] = (byte)(w >> 8);
        b[offset + 5] = (byte)w;
    }

    public static final void encodeInt48LE(byte[] b, int offset, long v) {
        int w = (int)v;
        b[offset] = (byte)w;
        b[offset + 1] = (byte)(w >> 8);
        b[offset + 2] = (byte)(w >> 16);
        b[offset + 3] = (byte)(w >> 24);
        w = (int)(v >> 32);
        b[offset + 4] = (byte)w;
        b[offset + 5] = (byte)(w >> 8);
    }

    public static final void encodeLongBE(byte[] b, int offset, long v) {
        int w = (int)(v >> 32);
        b[offset] = (byte)(w >> 24);
        b[offset + 1] = (byte)(w >> 16);
        b[offset + 2] = (byte)(w >> 8);
        b[offset + 3] = (byte)w;
        w = (int)v;
        b[offset + 4] = (byte)(w >> 24);
        b[offset + 5] = (byte)(w >> 16);
        b[offset + 6] = (byte)(w >> 8);
        b[offset + 7] = (byte)w;
    }

    public static final void encodeLongLE(byte[] b, int offset, long v) {
        int w = (int)v;
        b[offset] = (byte)w;
        b[offset + 1] = (byte)(w >> 8);
        b[offset + 2] = (byte)(w >> 16);
        b[offset + 3] = (byte)(w >> 24);
        w = (int)(v >> 32);
        b[offset + 4] = (byte)w;
        b[offset + 5] = (byte)(w >> 8);
        b[offset + 6] = (byte)(w >> 16);
        b[offset + 7] = (byte)(w >> 24);
    }

    public static final int decodeUnsignedShortBE(byte[] b, int offset) {
        return (b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF;
    }

    public static final int decodeUnsignedShortLE(byte[] b, int offset) {
        return b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8;
    }

    public static final int decodeIntBE(byte[] b, int offset) {
        return b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF;
    }

    public static final int decodeIntLE(byte[] b, int offset) {
        return b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24;
    }

    public static final long decodeUnsignedInt48BE(byte[] b, int offset) {
        return (long)((b[offset] & 0xFF) << 8 | b[offset + 1] & 0xFF) << 32 | (long)(b[offset + 2] << 24 | (b[offset + 3] & 0xFF) << 16 | (b[offset + 4] & 0xFF) << 8 | b[offset + 5] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long decodeUnsignedInt48LE(byte[] b, int offset) {
        return (long)(b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24) & 0xFFFFFFFFL | (long)(b[offset + 4] & 0xFF | (b[offset + 5] & 0xFF) << 8) << 32;
    }

    public static final long decodeLongBE(byte[] b, int offset) {
        return (long)(b[offset] << 24 | (b[offset + 1] & 0xFF) << 16 | (b[offset + 2] & 0xFF) << 8 | b[offset + 3] & 0xFF) << 32 | (long)(b[offset + 4] << 24 | (b[offset + 5] & 0xFF) << 16 | (b[offset + 6] & 0xFF) << 8 | b[offset + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final long decodeLongLE(byte[] b, int offset) {
        return (long)(b[offset] & 0xFF | (b[offset + 1] & 0xFF) << 8 | (b[offset + 2] & 0xFF) << 16 | b[offset + 3] << 24) & 0xFFFFFFFFL | (long)(b[offset + 4] & 0xFF | (b[offset + 5] & 0xFF) << 8 | (b[offset + 6] & 0xFF) << 16 | b[offset + 7] << 24) << 32;
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        if (len > 0) {
            while (true) {
                int amt;
                if ((amt = in.read(b, off, len)) <= 0) {
                    throw new EOFException();
                }
                if ((len -= amt) <= 0) break;
                off += amt;
            }
        }
    }

    public static boolean delete(Buffer bb) {
        if (!cDeleteUnsupported) {
            try {
                Method m = bb.getClass().getMethod("cleaner", new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    Object cleaner = m.invoke((Object)bb, new Object[0]);
                    if (cleaner != null && (m = cleaner.getClass().getMethod("clean", new Class[0])) != null) {
                        m.setAccessible(true);
                        m.invoke(cleaner, new Object[0]);
                        return true;
                    }
                }
            }
            catch (Exception e) {
                cDeleteUnsupported = true;
            }
        }
        return false;
    }

    public static String intToUnsignedString(int i) {
        try {
            return cIntToUnsignedString.invokeExact(i);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static String doIntToUnsignedString(int i) {
        return Long.toString((long)i & 0xFFFFFFFFL);
    }

    public static String longToUnsignedString(long i) {
        try {
            return cLongToUnsignedString.invokeExact(i);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static String doLongToUnsignedString(long i) {
        if (i >= 0L) {
            return Long.toString(i);
        }
        long quot = (i >>> 1) / 5L;
        long rem = i - quot * 10L;
        return Long.toString(quot) + rem;
    }

    public static long longValueExact(BigInteger bi) {
        try {
            return cBigIntegerLongValueExact.invokeExact(bi);
        }
        catch (Throwable e) {
            throw Utils.rethrow(e);
        }
    }

    private static long doLongValueExact(BigInteger bi) {
        long i = bi.longValue();
        if (!bi.equals(BigInteger.valueOf(i))) {
            throw new ArithmeticException("BigInteger out of long range");
        }
        return i;
    }

    public static RuntimeException rethrow(Throwable e) {
        Utils.castAndThrow(e);
        return null;
    }

    private static <T extends Throwable> void castAndThrow(Throwable e) throws T {
        throw e;
    }

    static {
        MethodHandle m;
        MethodType type = MethodType.methodType(String.class, Integer.TYPE);
        try {
            m = MethodHandles.publicLookup().findStatic(Integer.class, "toUnsignedString", type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                m = MethodHandles.lookup().findStatic(Utils.class, "doIntToUnsignedString", type);
            }
            catch (Throwable e2) {
                throw Utils.rethrow(e2);
            }
        }
        cIntToUnsignedString = m;
        type = MethodType.methodType(String.class, Long.TYPE);
        try {
            m = MethodHandles.publicLookup().findStatic(Long.class, "toUnsignedString", type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            try {
                m = MethodHandles.lookup().findStatic(Utils.class, "doLongToUnsignedString", type);
            }
            catch (Throwable e2) {
                throw Utils.rethrow(e2);
            }
        }
        cLongToUnsignedString = m;
        type = MethodType.methodType(Long.TYPE);
        try {
            m = MethodHandles.publicLookup().findVirtual(BigInteger.class, "longValueExact", type);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            type = MethodType.methodType(Long.TYPE, BigInteger.class);
            try {
                m = MethodHandles.lookup().findStatic(Utils.class, "doLongValueExact", type);
            }
            catch (Throwable e2) {
                throw Utils.rethrow(e2);
            }
        }
        cBigIntegerLongValueExact = m;
    }
}

