/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.utils;

public final class Validate {
    private Validate() {
    }

    public static int isPositive(int num, String fieldName) {
        if (num <= 0) {
            throw new IllegalArgumentException(String.format("%s must be positive", fieldName));
        }
        return num;
    }

    public static <T> void notNull(T obj, String fieldName) {
        if (obj == null) {
            throw Validate.nullParameterException(fieldName);
        }
    }

    private static IllegalArgumentException nullParameterException(String valueName) {
        return new IllegalArgumentException(String.format("'%s' cannot be null", valueName));
    }
}

