/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionMetrics;
import software.amazon.awssdk.services.dynamodb.model.PutItemRequest;
import software.amazon.awssdk.services.dynamodb.model.PutItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ReturnItemCollectionMetrics;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.com.amazon.dax.Constants;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.RefreshingCache;
import software.amazon.dax.dynamodb.SimpleCache;

public class PutItemResponseHandler
extends ResponseHandler<PutItemResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final RefreshingCache<String, List<AttributeDefinition>> keyCache;
    private final PutItemRequest request;

    public PutItemResponseHandler(CompletableFuture<PutItemResponse> completableFuture, RefreshingCache<String, List<AttributeDefinition>> keyCache, SimpleCache<Long, List<String>> attrListCache, PutItemRequest request) {
        super(completableFuture);
        this.attrListCache = attrListCache;
        this.keyCache = keyCache;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<PutItemResponse> completableFuture) throws ExecutionException, InterruptedException, IOException {
        this.keyCache.get(this.request.tableName()).whenComplete((keys, ex) -> {
            if (ex != null) {
                completableFuture.completeExceptionally((Throwable)ex);
            } else {
                try {
                    ConcurrentHashMap<Constants.DaxResponseParam, Object> response = new ConcurrentHashMap<Constants.DaxResponseParam, Object>();
                    DaxResponseDecoder.decodeResponse(in, keys, this.attrListCache, response).whenComplete((res, e) -> {
                        if (e != null) {
                            completableFuture.completeExceptionally((Throwable)e);
                        } else {
                            completableFuture.complete(this.buildResponse((Map<Constants.DaxResponseParam, Object>)res, (List<AttributeDefinition>)keys));
                        }
                    });
                }
                catch (Exception exception) {
                    completableFuture.completeExceptionally(exception);
                }
            }
        });
    }

    private PutItemResponse buildResponse(Map<Constants.DaxResponseParam, Object> response, List<AttributeDefinition> keys) {
        ItemCollectionMetrics itemCollectionMetrics;
        ReturnItemCollectionMetrics returnItemCollectionMetrics;
        ReturnConsumedCapacity returnConsumedCapacity;
        PutItemResponse.Builder result = PutItemResponse.builder();
        Map item = (Map)response.get((Object)Constants.DaxResponseParam.Attributes);
        ReturnConsumedCapacity returnConsumedCapacity2 = returnConsumedCapacity = this.request.returnConsumedCapacity() == null ? ReturnConsumedCapacity.NONE : this.request.returnConsumedCapacity();
        if (!returnConsumedCapacity.equals((Object)ReturnConsumedCapacity.NONE)) {
            ConsumedCapacity consumedCapacity = (ConsumedCapacity)response.get((Object)Constants.DaxResponseParam.ConsumedCapacity);
            if (null == consumedCapacity) {
                consumedCapacity = DaxResponseDecoder.newZeroConsumedCapacity(this.request.tableName());
            }
            result.consumedCapacity(consumedCapacity);
        }
        ReturnItemCollectionMetrics returnItemCollectionMetrics2 = returnItemCollectionMetrics = this.request.returnItemCollectionMetrics() == null ? ReturnItemCollectionMetrics.NONE : this.request.returnItemCollectionMetrics();
        if (!returnItemCollectionMetrics.equals((Object)ReturnItemCollectionMetrics.NONE) && (itemCollectionMetrics = (ItemCollectionMetrics)response.get((Object)Constants.DaxResponseParam.ItemCollectionMetrics)) != null) {
            result.itemCollectionMetrics(itemCollectionMetrics);
        }
        if (item != null) {
            for (AttributeDefinition key : keys) {
                String keyName = key.attributeName();
                item.put(keyName, (AttributeValue)this.request.item().get(keyName));
            }
            result.attributes(item);
        }
        return (PutItemResponse)result.build();
    }
}

