/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.io.InputStream;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.exceptions.DaxServiceException;

public class StatusCodeHandler
extends ChannelInboundHandlerAdapter {
    private static final int SUCCESS = 128;
    private final boolean containStatusCode;

    public StatusCodeHandler(boolean containStatusCode) {
        this.containStatusCode = containStatusCode;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            DaxCborInputStream in = new DaxCborInputStream((InputStream)new ByteBufInputStream((ByteBuf)msg, true), 128);
            try {
                if (this.containStatusCode) {
                    int statusCode = in.fieldType();
                    if (statusCode != 128) {
                        DaxServiceException e = DaxServiceException.pickException(in);
                        super.exceptionCaught(ctx, (Throwable)((Object)e));
                        in.close();
                        return;
                    }
                    in.consumeField();
                }
            }
            catch (Throwable t) {
                in.close();
                ctx.fireExceptionCaught(t);
                return;
            }
            super.channelRead(ctx, (Object)in);
        } else {
            super.channelRead(ctx, msg);
        }
    }
}

