/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.utils.Validate;

public class OldConnectionReaperHandler
extends ChannelDuplexHandler {
    private final int connectionTtlMillis;
    private ScheduledFuture<?> channelKiller;

    public OldConnectionReaperHandler(int connectionTtlMillis) {
        Validate.isPositive(connectionTtlMillis, "connectionTtlMillis");
        this.connectionTtlMillis = connectionTtlMillis;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelRegistered(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (this.channelKiller == null) {
            this.channelKiller = ctx.channel().eventLoop().schedule(() -> this.closeChannel(ctx), (long)this.connectionTtlMillis, TimeUnit.MILLISECONDS);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.destroy();
    }

    private void destroy() {
        if (this.channelKiller != null) {
            this.channelKiller.cancel(false);
            this.channelKiller = null;
        }
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (ctx.channel().isOpen()) {
            if (Boolean.FALSE.equals(ctx.channel().attr(ChannelAttributeKey.IN_USE).get())) {
                ctx.close();
            } else {
                ctx.channel().attr(ChannelAttributeKey.CLOSE_ON_RELEASE).set((Object)true);
            }
        }
        this.channelKiller = null;
    }
}

