/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.dynamodb;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.ItemResponse;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsRequest;
import software.amazon.awssdk.services.dynamodb.model.TransactGetItemsResponse;
import software.amazon.dax.com.amazon.dax.bits.DaxCborInputStream;
import software.amazon.dax.com.amazon.dax.bits.dynamodb.DynamoNumerals;
import software.amazon.dax.dynamodb.AttributeValueDecoder;
import software.amazon.dax.dynamodb.DaxResponseDecoder;
import software.amazon.dax.dynamodb.DocumentPath;
import software.amazon.dax.dynamodb.SimpleCache;
import software.amazon.dax.dynamodb.TransactionResponseHandler;

public class TransactGetItemsResponseHandler
extends TransactionResponseHandler<TransactGetItemsResponse> {
    private final SimpleCache<Long, List<String>> attrListCache;
    private final AtomicReference<List<Map<Integer, DocumentPath>>> projectionOrdinalsPerRequest;
    private final AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest;
    private final AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable;
    private final TransactGetItemsRequest request;

    public TransactGetItemsResponseHandler(CompletableFuture<TransactGetItemsResponse> completableFuture, SimpleCache<Long, List<String>> attrListCache, AtomicReference<List<Map<Integer, DocumentPath>>> projectionOrdinalsPerRequest, AtomicReference<List<Map<String, AttributeValue>>> keysPerRequest, AtomicReference<Map<String, List<AttributeDefinition>>> keyDefPerTable, TransactGetItemsRequest request) {
        super(completableFuture, keysPerRequest, attrListCache);
        this.attrListCache = attrListCache;
        this.projectionOrdinalsPerRequest = projectionOrdinalsPerRequest;
        this.keysPerRequest = keysPerRequest;
        this.keyDefPerTable = keyDefPerTable;
        this.request = request;
    }

    @Override
    public void decode(DaxCborInputStream in, CompletableFuture<TransactGetItemsResponse> completableFuture) throws Exception {
        int arrayLen = in.readArrayLength();
        if (arrayLen != 2) {
            throw new UnsupportedEncodingException("TransactGetResponse needs to have 2 elements, instead had: " + arrayLen);
        }
        int numItems = in.readArrayLength();
        ItemResponse[] itemResponses = new ItemResponse[numItems];
        CompletableFuture[] futures = new CompletableFuture[numItems];
        for (int i = 0; i < numItems; ++i) {
            int index = i;
            Map<Integer, DocumentPath> projectionOrdinals = this.projectionOrdinalsPerRequest.get().get(i);
            futures[i] = AttributeValueDecoder.decodeValue(in, projectionOrdinals, this.attrListCache).thenApply(item -> {
                if (item != null && projectionOrdinals == null) {
                    item.putAll(this.keysPerRequest.get().get(index));
                }
                itemResponses[index] = (ItemResponse)ItemResponse.builder().item(item).build();
                return null;
            });
        }
        int consumedCapacityArrayLen = in.readArrayLength();
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (consumedCapacityArrayLen > 0) {
            consumedCapacities = new ArrayList<ConsumedCapacity>(consumedCapacityArrayLen);
            while (consumedCapacityArrayLen-- > 0) {
                consumedCapacities.add(DaxResponseDecoder.decodeConsumedCapacityExtended(in));
            }
        }
        TransactGetItemsResponse.Builder transactGetItemsResponse = TransactGetItemsResponse.builder().consumedCapacity(consumedCapacities);
        if (DynamoNumerals.ReturnConsumedCapacity.fromName(this.request.returnConsumedCapacityAsString()) != DynamoNumerals.ReturnConsumedCapacity.NONE) {
            transactGetItemsResponse.consumedCapacity(DaxResponseDecoder.verifyBatchConsumedCapacity(consumedCapacities, this.keyDefPerTable.get().keySet()));
        }
        CompletableFuture.allOf(futures).whenComplete((placeholder, ex) -> {
            if (ex != null) {
                completableFuture.completeExceptionally((Throwable)ex);
            } else {
                completableFuture.complete((TransactGetItemsResponse)transactGetItemsResponse.responses(itemResponses).build());
            }
        });
    }
}

