/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.WriteTimeoutHandler;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import software.amazon.awssdk.http.nio.netty.internal.utils.ChannelUtils;
import software.amazon.dax.Configuration;
import software.amazon.dax.InternalConfiguration;
import software.amazon.dax.channel.ChannelAttributeKey;
import software.amazon.dax.channel.RequestContext;
import software.amazon.dax.channel.RequestEncoder;
import software.amazon.dax.channel.ResponseHandler;
import software.amazon.dax.exceptions.ExceptionHandler;

public class RequestExecutor {
    private final ChannelPool channelPool;
    private final EventLoopGroup eventLoopGroup;
    private final Configuration configuration;
    private final InternalConfiguration internalConfiguration;

    public RequestExecutor(ChannelPool channelPool, Configuration configuration, InternalConfiguration internalConfiguration) {
        this.channelPool = channelPool;
        this.eventLoopGroup = configuration.eventLoopGroup();
        this.configuration = configuration;
        this.internalConfiguration = internalConfiguration;
    }

    public <T, R> void execute(RequestEncoder<T> encoder, ResponseHandler<R> responseHandler, Supplier<T> requestSupplier) {
        CompletableFuture executeFuture = responseHandler.getCompletableFuture();
        Promise channelFuture = this.eventLoopGroup.next().newPromise();
        this.channelPool.acquire(channelFuture);
        channelFuture.addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                channel.attr(ChannelAttributeKey.REQUEST_CONTEXT_KEY).set((Object)RequestContext.createRequestContext(this.channelPool));
                if (this.tryConfigurePipeline(channel, encoder, responseHandler, executeFuture)) {
                    this.makeRequest(channel, requestSupplier, executeFuture);
                }
            } else {
                executeFuture.completeExceptionally((Throwable)ExceptionHandler.handleException(future.cause(), null));
            }
        });
    }

    private <T, R> void makeRequest(Channel channel, Supplier<T> requestSupplier, CompletableFuture<R> executeFuture) {
        channel.pipeline().addFirst(new ChannelHandler[]{new WriteTimeoutHandler((long)this.configuration.requestTimeoutMillis(), TimeUnit.MILLISECONDS)});
        channel.writeAndFlush(requestSupplier.get()).addListener(wireCall -> {
            ChannelUtils.removeIfExists((ChannelPipeline)channel.pipeline(), (Class[])new Class[]{WriteTimeoutHandler.class});
            if (wireCall.isSuccess()) {
                channel.pipeline().addFirst(new ChannelHandler[]{new ReadTimeoutHandler((long)this.configuration.requestTimeoutMillis(), TimeUnit.MILLISECONDS)});
                channel.read();
            } else {
                executeFuture.completeExceptionally((Throwable)ExceptionHandler.handleException(wireCall.cause(), channel));
                this.channelPool.release(channel);
            }
        });
    }

    private <T, R> boolean tryConfigurePipeline(Channel channel, RequestEncoder<T> encoder, ResponseHandler<R> responseHandler, CompletableFuture<R> executeFuture) {
        channel.pipeline().addLast(new ChannelHandler[]{encoder});
        channel.pipeline().addLast(new ChannelHandler[]{responseHandler});
        channel.attr(ChannelAttributeKey.IN_USE).set((Object)true);
        if (!channel.isActive()) {
            String errorMessage = "Channel was closed before it could be written to.";
            this.closeAndRelease(channel);
            executeFuture.completeExceptionally(new IOException(errorMessage));
            return false;
        }
        return true;
    }

    private void closeAndRelease(Channel channel) {
        channel.close();
        this.channelPool.release(channel);
    }
}

