/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dax.retry;

import java.time.Duration;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicyContext;
import software.amazon.awssdk.core.retry.RetryUtils;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;

public class DaxBackoffStrategy
implements BackoffStrategy {
    private static final int THROTTLED_BASE_DELAY_MS = 70;
    private static final int MAX_BACKOFF_MS = 20000;
    private final BackoffStrategy equalJitterBackoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(70L)).maxBackoffTime(Duration.ofMillis(20000L)).build();

    public Duration computeDelayBeforeNextRetry(RetryPolicyContext retryPolicyContext) {
        if (RetryUtils.isThrottlingException((SdkException)retryPolicyContext.exception())) {
            return this.equalJitterBackoffStrategy.computeDelayBeforeNextRetry(retryPolicyContext);
        }
        return Duration.ZERO;
    }
}

