/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;

public class RSAPrivateKey {
    public int _lengthBits;
    public DafnySequence<? extends Byte> _pem;
    private static final RSAPrivateKey theDefault = RSAPrivateKey.create(0, (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<RSAPrivateKey> _TYPE = TypeDescriptor.referenceWithInitializer(RSAPrivateKey.class, () -> RSAPrivateKey.Default());

    public RSAPrivateKey(int lengthBits, DafnySequence<? extends Byte> pem) {
        this._lengthBits = lengthBits;
        this._pem = pem;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RSAPrivateKey o = (RSAPrivateKey)other;
        return this._lengthBits == o._lengthBits && Objects.equals(this._pem, o._pem);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Integer.hashCode(this._lengthBits);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._pem);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.RSAPrivateKey.RSAPrivateKey");
        s.append("(");
        s.append(this._lengthBits);
        s.append(", ");
        s.append(Helpers.toString(this._pem));
        s.append(")");
        return s.toString();
    }

    public static RSAPrivateKey Default() {
        return theDefault;
    }

    public static TypeDescriptor<RSAPrivateKey> _typeDescriptor() {
        return _TYPE;
    }

    public static RSAPrivateKey create(int lengthBits, DafnySequence<? extends Byte> pem) {
        return new RSAPrivateKey(lengthBits, pem);
    }

    public static RSAPrivateKey create_RSAPrivateKey(int lengthBits, DafnySequence<? extends Byte> pem) {
        return RSAPrivateKey.create(lengthBits, pem);
    }

    public boolean is_RSAPrivateKey() {
        return true;
    }

    public int dtor_lengthBits() {
        return this._lengthBits;
    }

    public DafnySequence<? extends Byte> dtor_pem() {
        return this._pem;
    }
}

