/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.internaldafny.types;

import BoundedInts_Compile.uint8;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.primitives.internaldafny.types.RSAPaddingMode;

public class RSADecryptInput {
    public RSAPaddingMode _padding;
    public DafnySequence<? extends Byte> _privateKey;
    public DafnySequence<? extends Byte> _cipherText;
    private static final RSADecryptInput theDefault = RSADecryptInput.create(RSAPaddingMode.Default(), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()), (DafnySequence<? extends Byte>)DafnySequence.empty(uint8._typeDescriptor()));
    private static final TypeDescriptor<RSADecryptInput> _TYPE = TypeDescriptor.referenceWithInitializer(RSADecryptInput.class, () -> RSADecryptInput.Default());

    public RSADecryptInput(RSAPaddingMode padding, DafnySequence<? extends Byte> privateKey, DafnySequence<? extends Byte> cipherText) {
        this._padding = padding;
        this._privateKey = privateKey;
        this._cipherText = cipherText;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        RSADecryptInput o = (RSADecryptInput)other;
        return Objects.equals(this._padding, o._padding) && Objects.equals(this._privateKey, o._privateKey) && Objects.equals(this._cipherText, o._cipherText);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._padding);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._privateKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._cipherText);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyPrimitivesTypes.RSADecryptInput.RSADecryptInput");
        s.append("(");
        s.append(Helpers.toString((Object)this._padding));
        s.append(", ");
        s.append(Helpers.toString(this._privateKey));
        s.append(", ");
        s.append(Helpers.toString(this._cipherText));
        s.append(")");
        return s.toString();
    }

    public static RSADecryptInput Default() {
        return theDefault;
    }

    public static TypeDescriptor<RSADecryptInput> _typeDescriptor() {
        return _TYPE;
    }

    public static RSADecryptInput create(RSAPaddingMode padding, DafnySequence<? extends Byte> privateKey, DafnySequence<? extends Byte> cipherText) {
        return new RSADecryptInput(padding, privateKey, cipherText);
    }

    public static RSADecryptInput create_RSADecryptInput(RSAPaddingMode padding, DafnySequence<? extends Byte> privateKey, DafnySequence<? extends Byte> cipherText) {
        return RSADecryptInput.create(padding, privateKey, cipherText);
    }

    public boolean is_RSADecryptInput() {
        return true;
    }

    public RSAPaddingMode dtor_padding() {
        return this._padding;
    }

    public DafnySequence<? extends Byte> dtor_privateKey() {
        return this._privateKey;
    }

    public DafnySequence<? extends Byte> dtor_cipherText() {
        return this._cipherText;
    }
}

