/*
 * Decompiled with CFR 0.152.
 */
package RawECDHKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import BoundedInts_Compile.uint8;
import RawECDHKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.RawEcdhStaticConfigurations;

public class OnDecryptEcdhDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public RawEcdhStaticConfigurations _keyAgreementScheme = RawEcdhStaticConfigurations.Default();
    public DafnySequence<? extends Byte> _compressedRecipientPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    public DafnySequence<? extends Byte> _compressedSenderPublicKey = DafnySequence.empty(uint8._typeDescriptor());
    private static final TypeDescriptor<OnDecryptEcdhDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(OnDecryptEcdhDataKeyFilter.class, () -> null);

    public void __ctor(RawEcdhStaticConfigurations keyAgreementScheme, DafnySequence<? extends Byte> compressedRecipientPublicKey, Option<DafnySequence<? extends Byte>> compressedSenderPublicKey) {
        this._keyAgreementScheme = keyAgreementScheme;
        this._compressedRecipientPublicKey = compressedRecipientPublicKey;
        this._compressedSenderPublicKey = compressedSenderPublicKey.is_Some() ? compressedSenderPublicKey.dtor_value() : DafnySequence.empty(uint8._typeDescriptor());
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> res = Result.Default(false);
        DafnySequence<? extends Byte> _1268_providerInfo = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _1269_providerId = edk.dtor_keyProviderId();
        if (!_1269_providerId.equals(Constants_Compile.__default.RAW__ECDH__PROVIDER__ID()) && !_1269_providerId.equals(Constants_Compile.__default.KMS__ECDH__PROVIDER__ID())) {
            res = Result.create_Success(false);
            return res;
        }
        Outcome<Object> _1270_valueOrError0 = Outcome.Default();
        _1270_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_1268_providerInfo.length()).compareTo(BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__521__LEN()))) <= 0 && __default.ValidProviderInfoLength(_1268_providerInfo), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"EDK ProviderInfo longer than expected")));
        if (_1270_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _1270_valueOrError0.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        byte _1271_keyringVersion = (Byte)_1268_providerInfo.select(Helpers.toInt((BigInteger)BigInteger.ZERO));
        Outcome<Object> _1272_valueOrError1 = Outcome.Default();
        _1272_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), DafnySequence.of((byte[])new byte[]{_1271_keyringVersion}).equals(__default.RAW__ECDH__KEYRING__VERSION()), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Incorrect Keyring version found in provider info.")));
        if (_1272_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _1272_valueOrError1.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        BigInteger _1273_recipientPublicKeyLength = BigInteger.ZERO;
        _1273_recipientPublicKeyLength = BigInteger.valueOf(Integer.toUnsignedLong(StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)_1268_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPL__INDEX(), Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX()))));
        BigInteger _1274_recipientPublicKeyLengthIndex = BigInteger.ZERO;
        _1274_recipientPublicKeyLengthIndex = BigInteger.valueOf(Integer.toUnsignedLong(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX())).add(_1273_recipientPublicKeyLength);
        BigInteger _1275_senderPublicKeyIndex = BigInteger.ZERO;
        _1275_senderPublicKeyIndex = _1274_recipientPublicKeyLengthIndex.add(Constants_Compile.__default.ECDH__PROVIDER__INFO__PUBLIC__KEY__LEN());
        Outcome<Object> _1276_valueOrError2 = Outcome.Default();
        _1276_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _1274_recipientPublicKeyLengthIndex.add(BigInteger.valueOf(4L)).compareTo(BigInteger.valueOf(_1268_providerInfo.length())) < 0, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Key Provider Info Serialization Error. Serialized length less than expected.")));
        if (_1276_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _1276_valueOrError2.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        DafnySequence _1277_providerInfoRecipientPublicKey = _1268_providerInfo.subsequence(Constants_Compile.__default.ECDH__PROVIDER__INFO__RPK__INDEX(), Helpers.toInt((BigInteger)_1274_recipientPublicKeyLengthIndex));
        DafnySequence _1278_providerInfoSenderPublicKey = _1268_providerInfo.drop(_1275_senderPublicKeyIndex);
        if (this.keyAgreementScheme().is_PublicKeyDiscovery()) {
            res = Result.create_Success(this.compressedRecipientPublicKey().equals((Object)_1277_providerInfoRecipientPublicKey));
            return res;
        }
        res = Result.create_Success(this.compressedSenderPublicKey().equals((Object)_1278_providerInfoSenderPublicKey) && this.compressedRecipientPublicKey().equals((Object)_1277_providerInfoRecipientPublicKey) || this.compressedSenderPublicKey().equals((Object)_1277_providerInfoRecipientPublicKey) && this.compressedRecipientPublicKey().equals((Object)_1278_providerInfoSenderPublicKey));
        return res;
    }

    public RawEcdhStaticConfigurations keyAgreementScheme() {
        return this._keyAgreementScheme;
    }

    public DafnySequence<? extends Byte> compressedRecipientPublicKey() {
        return this._compressedRecipientPublicKey;
    }

    public DafnySequence<? extends Byte> compressedSenderPublicKey() {
        return this._compressedSenderPublicKey;
    }

    public static TypeDescriptor<OnDecryptEcdhDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawECDHKeyring.OnDecryptEcdhDataKeyFilter";
    }
}

