/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsHierarchicalKeyring_Compile.HierarchyUnwrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyUnwrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DecryptionMaterials _materials = null;
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Character> _branchKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, IKeyStoreClient keyStore, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Character> branchKeyId, long ttlSeconds, ICryptographicMaterialsCache cache) {
        this._materials = materials;
        this._keyStore = keyStore;
        this._cryptoPrimitives = cryptoPrimitives;
        this._branchKeyId = branchKeyId;
        this._ttlSeconds = ttlSeconds;
        this._cache = cache;
    }

    @Override
    public Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out170;
        Result<AtomicPrimitivesClient, Error> _out169;
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        Outcome<Object> _975_valueOrError0 = Outcome.Default();
        _975_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider info for Hierarchical Keyring")));
        if (_975_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _975_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _976_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _977_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _978_branchKeyIdUtf8 = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _979_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _981_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _981_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_979_ciphertext, _976_suite);
        if (_981_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _981_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _980_providerWrappedMaterial = (DafnySequence)_981_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _982_valueOrError2 = Outcome.Default();
        _982_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_980_providerWrappedMaterial.length()).compareTo(BigInteger.valueOf(__default.EDK__CIPHERTEXT__VERSION__INDEX())) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_982_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _982_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _983_branchKeyVersionUuid = _980_providerWrappedMaterial.subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
        Result<Object, Object> _985_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _985_valueOrError3 = UUID.__default.FromByteArray((DafnySequence<? extends Byte>)_983_branchKeyVersionUuid).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_985_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _985_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _984_version = (DafnySequence)_985_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _987_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out167 = this.GetVersionCacheId(_978_branchKeyIdUtf8, (DafnySequence<? extends Character>)_984_version, this.cryptoPrimitives());
        _987_valueOrError4 = _out167;
        if (_987_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _987_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _986_cacheId = (DafnySequence)_987_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _989_valueOrError5 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out168 = this.GetHierarchicalMaterialsVersion(this.branchKeyId(), _978_branchKeyIdUtf8, (DafnySequence<? extends Character>)_984_version, (DafnySequence<? extends Byte>)_986_cacheId);
        _989_valueOrError5 = _out168;
        if (_989_valueOrError5.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _989_valueOrError5.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _988_hierarchicalMaterials = _989_valueOrError5.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _990_branchKey = _988_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _991_branchKeyVersion = _988_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _993_valueOrError6 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _993_valueOrError6 = UTF8.__default.Decode(_991_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_993_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _993_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _992_branchKeyVersionAsString = (DafnySequence)_993_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _995_valueOrError7 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _995_valueOrError7 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_992_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_995_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _995_valueOrError7.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _994_branchKeyVersionAsBytes = (DafnySequence)_995_valueOrError7.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<AtomicPrimitivesClient, Error> _996_maybeCrypto = _out169 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result<AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _998_valueOrError8 = null;
        _998_valueOrError8 = _996_maybeCrypto.MapFailure(AtomicPrimitivesClient._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _999_e_boxed0 -> {
            Error _999_e = _999_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_999_e);
        });
        if (_998_valueOrError8.IsFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _998_valueOrError8.PropagateFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        IAwsCryptographicPrimitivesClient _997_cryptoPrimitivesX = _998_valueOrError8.Extract(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        AtomicPrimitivesClient _1000_cryptoPrimitives = (AtomicPrimitivesClient)_997_cryptoPrimitivesX;
        KmsHierarchyUnwrapKeyMaterial _nw37 = new KmsHierarchyUnwrapKeyMaterial();
        _nw37.__ctor(_990_branchKey, _978_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_994_branchKeyVersionAsBytes, _1000_cryptoPrimitives);
        KmsHierarchyUnwrapKeyMaterial _1001_kmsHierarchyUnwrap = _nw37;
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1002_unwrapOutputRes = _out170 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _1001_kmsHierarchyUnwrap);
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, Object> _1004_valueOrError9 = Result.Default(UnwrapEdkMaterialOutput.Default(HierarchyUnwrapInfo.Default()));
        _1004_valueOrError9 = _1002_unwrapOutputRes;
        if (_1004_valueOrError9.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1004_valueOrError9.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _1003_unwrapOutput = _1004_valueOrError9.Extract(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1006_valueOrError10 = null;
        _1006_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _1003_unwrapOutput.dtor_plaintextDataKey(), _1003_unwrapOutput.dtor_symmetricSigningKey());
        if (_1006_valueOrError10.IsFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _1006_valueOrError10.PropagateFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _1005_result = _1006_valueOrError10.Extract(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_1005_result);
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> branchKeyVersion, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out171;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _1007_valueOrError0 = Outcome.Default();
        _1007_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed42 -> {
            DafnySequence _pat_let21_0 = boxed42;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let21_0, boxed43 -> {
                DafnySequence _1008_branchKeyId = boxed43;
                return BigInteger.valueOf(_1008_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_1008_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_1007_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1007_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _1009_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _1010_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_1009_branchKeyId.cardinalityInt());
        Outcome<Object> _1011_valueOrError1 = Outcome.Default();
        _1011_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to represent as an ASCII string.")));
        if (_1011_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1011_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _1012_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
        DafnySequence _1013_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_1010_lenBranchKey, branchKeyIdUtf8), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _1012_versionBytes);
        DigestInput _1014_identifierDigestInput = DigestInput.create(DigestAlgorithm.create_SHA__512(), (DafnySequence<? extends Byte>)_1013_identifier);
        Result<DafnySequence<? extends Byte>, Error> _1015_maybeCacheDigest = _out171 = Digest_Compile.__default.Digest(_1014_identifierDigestInput);
        Result<Object, Object> _1017_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1017_valueOrError2 = _1015_maybeCacheDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1018_e_boxed0 -> {
            Error _1018_e = _1018_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1018_e);
        });
        if (_1017_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1017_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _1016_cacheDigest = (DafnySequence)_1017_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        cacheId = Result.create_Success(_1016_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> version, DafnySequence<? extends Byte> cacheId) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _1019_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out172 = __default.getEntry(this.cache(), _1019_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1020_getCacheOutput = _out172;
        if (_1020_getCacheOutput.is_Failure()) {
            long _out174;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out173;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _1021_maybeGetBranchKeyVersionOutput = _out173 = this.keyStore().GetBranchKeyVersion(GetBranchKeyVersionInput.create(branchKeyId, version));
            Result<GetBranchKeyVersionOutput, Object> _1023_valueOrError0 = Result.Default(GetBranchKeyVersionOutput.Default());
            _1023_valueOrError0 = _1021_maybeGetBranchKeyVersionOutput.MapFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1024_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _1024_e = _1024_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_1024_e);
            });
            if (_1023_valueOrError0.IsFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1023_valueOrError0.PropagateFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetBranchKeyVersionOutput _1022_getBranchKeyVersionOutput = _1023_valueOrError0.Extract(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _1025_branchKeyMaterials = _1022_getBranchKeyVersionOutput.dtor_branchKeyMaterials();
            long _1026_now = _out174 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _1027_valueOrError1 = Outcome.Default();
            _1027_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_1026_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_1027_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1027_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _1028_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_1025_branchKeyMaterials), _1026_now, this.ttlSeconds() + _1026_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _1030_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out175 = __default.putEntry(this.cache(), _1028_putCacheEntryInput);
            _1030_valueOrError2 = _out175;
            if (_1030_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1030_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _1029___v1 = _1030_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_1025_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _1031_valueOrError3 = Outcome.Default();
        _1031_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1020_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_1020_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_1020_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_1031_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _1031_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_1020_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Character> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.DecryptSingleEncryptedDataKey";
    }
}

