/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.__default;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create_kmsKeyArn((DafnySequence<? extends Character>)DafnySequence.asString((String)"arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        IKMSClient _327_kmsClient = null;
        IDynamoDBClient _328_ddbClient = null;
        Option<Object> _329_inferredRegion = Option.create_None();
        if (KMSKeystoreOperations_Compile.__default.HasKeyId(config.dtor_kmsConfiguration())) {
            Result<AwsArn, Error> _331_valueOrError0 = null;
            _331_valueOrError0 = KmsArn_Compile.__default.IsValidKeyArn(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration()));
            if (_331_valueOrError0.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
                res = _331_valueOrError0.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            AwsArn _330_parsedArn = _331_valueOrError0.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
            _329_inferredRegion = Option.create_Some(_330_parsedArn.dtor_region());
        } else if (config.dtor_kmsConfiguration().is_mrDiscovery()) {
            _329_inferredRegion = Option.create_Some(config.dtor_kmsConfiguration().dtor_mrDiscovery().dtor_region());
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _332_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _333_valueOrError1 = Outcome.Default();
        _333_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _332_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Grant Tokens passed to Key Store configuration are invalid.")));
        if (_333_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _333_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _334_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _334_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _336_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out44;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _335_maybeUuid = _out44 = UUID.__default.GenerateUUID();
            Result<Object, Object> _337_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _337_valueOrError2 = _335_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _338_e_boxed0 -> {
                DafnySequence _338_e = _338_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_338_e);
            });
            if (_337_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _337_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _334_keyStoreId = _336_uuid = (DafnySequence)_337_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        if (config.dtor_kmsClient().is_Some()) {
            _327_kmsClient = config.dtor_kmsClient().dtor_value();
        } else if (config.dtor_kmsClient().is_None() && _329_inferredRegion.is_Some()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out45;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _339_maybeKmsClient = _out45 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_329_inferredRegion.dtor_value()));
            Result<IKMSClient, Error> _340_valueOrError3 = null;
            _340_valueOrError3 = _339_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _341_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _341_e = _341_e_boxed0;
                return Error.create_ComAmazonawsKms(_341_e);
            });
            if (_340_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _340_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _327_kmsClient = _340_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out46;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _342_maybeKmsClient = _out46 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClient();
            Result<IKMSClient, Error> _343_valueOrError4 = null;
            _343_valueOrError4 = _342_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _344_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _344_e = _344_e_boxed0;
                return Error.create_ComAmazonawsKms(_344_e);
            });
            if (_343_valueOrError4.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _343_valueOrError4.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _327_kmsClient = _343_valueOrError4.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        }
        if (config.dtor_ddbClient().is_Some()) {
            _328_ddbClient = config.dtor_ddbClient().dtor_value();
        } else if (config.dtor_ddbClient().is_None() && _329_inferredRegion.is_Some()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out47;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _345_maybeDdbClient = _out47 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion((DafnySequence<? extends Character>)((DafnySequence)_329_inferredRegion.dtor_value()));
            Result<IDynamoDBClient, Error> _346_valueOrError5 = null;
            _346_valueOrError5 = _345_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _347_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _347_e = _347_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_347_e);
            });
            if (_346_valueOrError5.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _346_valueOrError5.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _328_ddbClient = _346_valueOrError5.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out48;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _348_maybeDdbClient = _out48 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DynamoDBClient();
            Result<IDynamoDBClient, Error> _349_valueOrError6 = null;
            _349_valueOrError6 = _348_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _350_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _350_e = _350_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_350_e);
            });
            if (_349_valueOrError6.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _349_valueOrError6.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _328_ddbClient = _349_valueOrError6.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        }
        Outcome<Object> _351_valueOrError7 = Outcome.Default();
        _351_valueOrError7 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_351_valueOrError7.IsFailure(Error._typeDescriptor())) {
            res = _351_valueOrError7.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw0 = new KeyStoreClient();
        _nw0.__ctor(Config.create((DafnySequence<? extends Character>)_334_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _332_grantTokens.dtor_value(), _327_kmsClient, _328_ddbClient));
        KeyStoreClient _352_client = _nw0;
        res = Result.create_Success(_352_client);
        return res;
    }

    public static Result<IKeyStoreClient, Error> CreateSuccessOfClient(IKeyStoreClient client) {
        return Result.create_Success(client);
    }

    public static Result<IKeyStoreClient, Error> CreateFailureOfError(Error error) {
        return Result.create_Failure(error);
    }

    public String toString() {
        return "KeyStore._default";
    }
}

