/*
 * Decompiled with CFR 0.152.
 */
package MultiKeyring_Compile;

import Keyring_Compile.VerifiableInterface;
import MultiKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;

public class MultiKeyring
implements VerifiableInterface,
IKeyring {
    public Option<IKeyring> _generatorKeyring = Option.Default();
    public DafnySequence<? extends IKeyring> _childKeyrings = DafnySequence.empty(_Companion_IKeyring._typeDescriptor());
    private static final TypeDescriptor<MultiKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(MultiKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out57 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out57;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out58 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out58;
    }

    public void __ctor(Option<IKeyring> generatorKeyring, DafnySequence<? extends IKeyring> childKeyrings) {
        this._generatorKeyring = generatorKeyring;
        this._childKeyrings = childKeyrings;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.generatorKeyring().is_None() && input.dtor_materials().dtor_plaintextDataKey().is_None()) {
            DafnySequence _425_exception = DafnySequence.asString((String)"Need either a generator keyring or input encryption materials which contain a plaintext data key");
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_425_exception));
            return res;
        }
        EncryptionMaterials _426_returnMaterials = input.dtor_materials();
        if (this.generatorKeyring().is_Some()) {
            Result<OnEncryptOutput, Error> _out59;
            Outcome<Object> _427_valueOrError0 = Outcome.Default();
            _427_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_plaintextDataKey().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"This multi keyring has a generator but provided Encryption Materials already contain plaintext data key")));
            if (_427_valueOrError0.IsFailure(Error._typeDescriptor())) {
                res = _427_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Result<OnEncryptOutput, Error> _428_onEncryptOutput = _out59 = this.generatorKeyring().dtor_value().OnEncrypt(input);
            Outcome<Object> _429_valueOrError1 = Outcome.Default();
            _429_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _428_onEncryptOutput.is_Success(), _428_onEncryptOutput.is_Failure() ? _428_onEncryptOutput.dtor_error() : Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected failure. Input to Need is !Success.")));
            if (_429_valueOrError1.IsFailure(Error._typeDescriptor())) {
                res = _429_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _430_valueOrError2 = Outcome.Default();
            _430_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _428_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Generator keyring returned invalid encryption materials")));
            if (_430_valueOrError2.IsFailure(Error._typeDescriptor())) {
                res = _430_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _426_returnMaterials = _428_onEncryptOutput.dtor_value().dtor_materials();
        }
        BigInteger _hi0 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _431_i = BigInteger.ZERO;
        while (_431_i.compareTo(_hi0) < 0) {
            Result<OnEncryptOutput, Error> _out60;
            OnEncryptInput _432_onEncryptInput = OnEncryptInput.create(_426_returnMaterials);
            Result<OnEncryptOutput, Error> _433_onEncryptOutput = _out60 = ((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_431_i))).OnEncrypt(_432_onEncryptInput);
            Outcome<Object> _434_valueOrError3 = Outcome.Default();
            _434_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _433_onEncryptOutput.is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring failed to encrypt plaintext data key")));
            if (_434_valueOrError3.IsFailure(Error._typeDescriptor())) {
                res = _434_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _435_valueOrError4 = Outcome.Default();
            _435_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_426_returnMaterials, _433_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring performed invalid transition on encryption materials")));
            if (_435_valueOrError4.IsFailure(Error._typeDescriptor())) {
                res = _435_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _426_returnMaterials = _433_onEncryptOutput.dtor_value().dtor_materials();
            _431_i = _431_i.add(BigInteger.ONE);
        }
        Outcome<Object> _436_valueOrError5 = Outcome.Default();
        _436_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _426_returnMaterials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A child or generator keyring modified the encryption materials in illegal ways.")));
        if (_436_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _436_valueOrError5.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(OnEncryptOutput.create(_426_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _437_materials = input.dtor_materials();
        Outcome<Object> _438_valueOrError0 = Outcome.Default();
        _438_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(input.dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_438_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _438_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _439_failures = DafnySequence.empty(Error._typeDescriptor());
        if (this.generatorKeyring().is_Some()) {
            Result<OnDecryptOutput, Error> _out61 = __default.AttemptDecryptDataKey(this.generatorKeyring().dtor_value(), input);
            Result<OnDecryptOutput, Error> _440_result = _out61;
            if (_440_result.is_Success()) {
                if (_440_result.dtor_value().dtor_materials().dtor_plaintextDataKey().is_Some()) {
                    res = Result.create_Success(_440_result.dtor_value());
                    return res;
                }
            } else {
                _439_failures = DafnySequence.concatenate((DafnySequence)_439_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_440_result.dtor_error()}));
            }
        }
        BigInteger _hi1 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _441_j = BigInteger.ZERO;
        while (_441_j.compareTo(_hi1) < 0) {
            Result<OnDecryptOutput, Error> _out62 = __default.AttemptDecryptDataKey((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_441_j)), input);
            Result<OnDecryptOutput, Error> _442_result = _out62;
            if (_442_result.is_Success()) {
                res = Result.create_Success(_442_result.dtor_value());
                return res;
            }
            _439_failures = DafnySequence.concatenate((DafnySequence)_439_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_442_result.dtor_error()}));
            _441_j = _441_j.add(BigInteger.ONE);
        }
        Error _443_combinedResult = Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_439_failures, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Keyring was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        res = Result.create_Failure(_443_combinedResult);
        return res;
    }

    public Option<IKeyring> generatorKeyring() {
        return this._generatorKeyring;
    }

    public DafnySequence<? extends IKeyring> childKeyrings() {
        return this._childKeyrings;
    }

    public static TypeDescriptor<MultiKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "MultiKeyring.MultiKeyring";
    }
}

