/*
 * Decompiled with CFR 0.152.
 */
package KMSKeystoreOperations_Compile;

import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsIdentifier;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.Discovery;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_discovery;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_kmsMRKeyArn;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration_mrDiscovery;
import software.amazon.cryptography.keystore.internaldafny.types.MRDiscovery;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.AttributeValue;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.DecryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.GenerateDataKeyWithoutPlaintextResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.ReEncryptResponse;

public class __default {
    public static DafnySequence<? extends Character> replaceRegion(DafnySequence<? extends Character> arn, DafnySequence<? extends Character> region) {
        Result<AwsArn, DafnySequence<? extends Character>> _139_parsed = AwsArnParsing_Compile.__default.ParseAwsKmsArn(arn);
        if (_139_parsed.is_Failure()) {
            return arn;
        }
        if (!AwsArnParsing_Compile.__default.IsMultiRegionAwsKmsArn(_139_parsed.dtor_value())) {
            return arn;
        }
        DafnySequence<? extends Character> _140_newArn = _139_parsed.dtor_value().ToArnString(Option.create_Some(region));
        if (software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(_140_newArn)) {
            return _140_newArn;
        }
        return arn;
    }

    public static DafnySequence<? extends Character> GetArn(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> discoverdArn) {
        MRDiscovery _147___mcc_h3;
        KMSConfiguration _source8 = kmsConfiguration;
        if (_source8.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _141___mcc_h0;
            DafnySequence<? extends Character> _142_arn = _141___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source8)._kmsKeyArn;
            return _142_arn;
        }
        if (_source8.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _143___mcc_h1;
            DafnySequence<? extends Character> _144_arn = _143___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source8)._kmsMRKeyArn;
            return _144_arn;
        }
        if (_source8.is_discovery()) {
            Discovery _145___mcc_h2;
            Discovery _146_obj = _145___mcc_h2 = ((KMSConfiguration_discovery)_source8)._discovery;
            return discoverdArn;
        }
        MRDiscovery _148_region = _147___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source8)._mrDiscovery;
        return __default.replaceRegion(discoverdArn, _148_region.dtor_region());
    }

    public static boolean AttemptKmsOperation_q(KMSConfiguration kmsConfiguration, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext) {
        MRDiscovery _155___mcc_h3;
        KMSConfiguration _source9 = kmsConfiguration;
        if (_source9.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _149___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source9)._kmsKeyArn;
            DafnySequence<? extends Character> _150_arn = _149___mcc_h0;
            return _150_arn.equals((Object)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_150_arn);
        }
        if (_source9.is_kmsMRKeyArn()) {
            DafnySequence<? extends Character> _151___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source9)._kmsMRKeyArn;
            DafnySequence<? extends Character> _152_arn = _151___mcc_h1;
            return __default.MrkMatch(_152_arn, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD()))) && KmsArn_Compile.__default.ValidKmsArn_q(_152_arn);
        }
        if (_source9.is_discovery()) {
            Discovery _153___mcc_h2;
            Discovery _154_obj = _153___mcc_h2 = ((KMSConfiguration_discovery)_source9)._discovery;
            return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        }
        MRDiscovery _156_obj = _155___mcc_h3 = ((KMSConfiguration_mrDiscovery)_source9)._mrDiscovery;
        return KmsArn_Compile.__default.ValidKmsArn_q((DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
    }

    public static boolean Compatible_q(KMSConfiguration kmsConfiguration, DafnySequence<? extends Character> keyId) {
        DafnySequence<? extends Character> _159___mcc_h1;
        KMSConfiguration _source10 = kmsConfiguration;
        if (_source10.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _157___mcc_h0;
            DafnySequence<? extends Character> _158_arn = _157___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source10)._kmsKeyArn;
            return _158_arn.equals(keyId);
        }
        DafnySequence<? extends Character> _160_arn = _159___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source10)._kmsMRKeyArn;
        return __default.MrkMatch(_160_arn, keyId);
    }

    public static boolean OptCompatible_q(KMSConfiguration kmsConfiguration, Option<DafnySequence<? extends Character>> keyId) {
        return keyId.is_Some() && __default.Compatible_q(kmsConfiguration, keyId.dtor_value());
    }

    public static boolean MrkMatch(DafnySequence<? extends Character> x, DafnySequence<? extends Character> y) {
        Result<AwsArn, DafnySequence<? extends Character>> _161_xArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(x);
        Result<AwsArn, DafnySequence<? extends Character>> _162_yArn = AwsArnParsing_Compile.__default.ParseAwsKmsArn(y);
        if (_161_xArn.is_Failure() || _162_yArn.is_Failure()) {
            return false;
        }
        return AwsKmsMrkMatchForDecrypt_Compile.__default.AwsKmsMrkMatchForDecrypt(AwsKmsIdentifier.create_AwsKmsArnIdentifier(_161_xArn.dtor_value()), AwsKmsIdentifier.create_AwsKmsArnIdentifier(_162_yArn.dtor_value()));
    }

    public static boolean HasKeyId(KMSConfiguration kmsConfiguration) {
        return kmsConfiguration.is_kmsKeyArn() || kmsConfiguration.is_kmsMRKeyArn();
    }

    public static DafnySequence<? extends Character> GetKeyId(KMSConfiguration kmsConfiguration) {
        DafnySequence<? extends Character> _165___mcc_h1;
        KMSConfiguration _source11 = kmsConfiguration;
        if (_source11.is_kmsKeyArn()) {
            DafnySequence<? extends Character> _163___mcc_h0;
            DafnySequence<? extends Character> _164_arn = _163___mcc_h0 = ((KMSConfiguration_kmsKeyArn)_source11)._kmsKeyArn;
            return _164_arn;
        }
        DafnySequence<? extends Character> _166_arn = _165___mcc_h1 = ((KMSConfiguration_kmsMRKeyArn)_source11)._kmsMRKeyArn;
        return _166_arn;
    }

    public static Result<GenerateDataKeyWithoutPlaintextResponse, Error> GenerateKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out10;
        Result<GenerateDataKeyWithoutPlaintextResponse, Error> res = Result.Default(GenerateDataKeyWithoutPlaintextResponse.Default());
        DafnySequence<? extends Character> _167_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        GenerateDataKeyWithoutPlaintextRequest _168_generatorRequest = GenerateDataKeyWithoutPlaintextRequest.create(_167_kmsKeyArn, Option.create_Some(encryptionContext), Option.create_None(), Option.create_Some(32), Option.create_Some(grantTokens));
        Result<GenerateDataKeyWithoutPlaintextResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _169_maybeGenerateResponse = _out10 = kmsClient.GenerateDataKeyWithoutPlaintext(_168_generatorRequest);
        Result<GenerateDataKeyWithoutPlaintextResponse, Object> _171_valueOrError0 = Result.Default(GenerateDataKeyWithoutPlaintextResponse.Default());
        _171_valueOrError0 = _169_maybeGenerateResponse.MapFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _172_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _172_e = _172_e_boxed0;
            return Error.create_ComAmazonawsKms(_172_e);
        });
        if (_171_valueOrError0.IsFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _171_valueOrError0.PropagateFailure(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        GenerateDataKeyWithoutPlaintextResponse _170_generateResponse = _171_valueOrError0.Extract(GenerateDataKeyWithoutPlaintextResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _173_valueOrError1 = Outcome.Default();
        _173_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _170_generateResponse.dtor_KeyId().is_Some(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS GenerateDataKey:: Invalid Key Id")));
        if (_173_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _173_valueOrError1.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        Outcome<Object> _174_valueOrError2 = Outcome.Default();
        _174_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _170_generateResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_170_generateResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Invalid ciphertext")));
        if (_174_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _174_valueOrError2.PropagateFailure(Error._typeDescriptor(), GenerateDataKeyWithoutPlaintextResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(_170_generateResponse);
        return res;
    }

    public static Result<ReEncryptResponse, Error> ReEncryptKey(DafnySequence<? extends Byte> ciphertext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> sourceEncryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> destinationEncryptionContext, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out11;
        Result<ReEncryptResponse, Error> res = Result.Default(ReEncryptResponse.Default());
        DafnySequence<? extends Character> _175_kmsKeyArn = __default.GetKeyId(kmsConfiguration);
        ReEncryptRequest _176_reEncryptRequest = ReEncryptRequest.create(ciphertext, Option.create_Some(sourceEncryptionContext), Option.create_Some(_175_kmsKeyArn), _175_kmsKeyArn, Option.create_Some(destinationEncryptionContext), Option.create_None(), Option.create_None(), Option.create_Some(grantTokens));
        Result<ReEncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _177_maybeReEncryptResponse = _out11 = kmsClient.ReEncrypt(_176_reEncryptRequest);
        Result<ReEncryptResponse, Object> _179_valueOrError0 = Result.Default(ReEncryptResponse.Default());
        _179_valueOrError0 = _177_maybeReEncryptResponse.MapFailure(ReEncryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _180_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _180_e = _180_e_boxed0;
            return Error.create_ComAmazonawsKms(_180_e);
        });
        if (_179_valueOrError0.IsFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _179_valueOrError0.PropagateFailure(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        ReEncryptResponse _178_reEncryptResponse = _179_valueOrError0.Extract(ReEncryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _181_valueOrError1 = Outcome.Default();
        _181_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _178_reEncryptResponse.dtor_SourceKeyId().is_Some() && _178_reEncryptResponse.dtor_KeyId().is_Some() && _178_reEncryptResponse.dtor_SourceKeyId().dtor_value().equals(_175_kmsKeyArn) && _178_reEncryptResponse.dtor_KeyId().dtor_value().equals(_175_kmsKeyArn), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from KMS ReEncrypt:: Invalid Key Id")));
        if (_181_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _181_valueOrError1.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        Outcome<Object> _182_valueOrError2 = Outcome.Default();
        _182_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _178_reEncryptResponse.dtor_CiphertextBlob().is_Some() && software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__CiphertextType(_178_reEncryptResponse.dtor_CiphertextBlob().dtor_value()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS ReEncrypt: Invalid ciphertext.")));
        if (_182_valueOrError2.IsFailure(Error._typeDescriptor())) {
            res = _182_valueOrError2.PropagateFailure(Error._typeDescriptor(), ReEncryptResponse._typeDescriptor());
            return res;
        }
        res = Result.create_Success(_178_reEncryptResponse);
        return res;
    }

    public static Result<DecryptResponse, Error> DecryptKey(DafnyMap<? extends DafnySequence<? extends Character>, ? extends DafnySequence<? extends Character>> encryptionContext, DafnyMap<? extends DafnySequence<? extends Character>, ? extends AttributeValue> item, KMSConfiguration kmsConfiguration, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens, IKMSClient kmsClient) {
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out12;
        Result<DecryptResponse, Error> output = Result.Default(DecryptResponse.Default());
        DafnySequence<? extends Character> _183_kmsKeyArn = __default.GetArn(kmsConfiguration, (DafnySequence<? extends Character>)((DafnySequence)encryptionContext.get(Structure_Compile.__default.KMS__FIELD())));
        Result<DecryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _184_maybeDecryptResponse = _out12 = kmsClient.Decrypt(DecryptRequest.create(((AttributeValue)item.get(Structure_Compile.__default.BRANCH__KEY__FIELD())).dtor_B(), Option.create_Some(encryptionContext), Option.create_Some(grantTokens), Option.create_Some(_183_kmsKeyArn), Option.create_None()));
        Result<DecryptResponse, Object> _186_valueOrError0 = Result.Default(DecryptResponse.Default());
        _186_valueOrError0 = _184_maybeDecryptResponse.MapFailure(DecryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _187_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _187_e = _187_e_boxed0;
            return Error.create_ComAmazonawsKms(_187_e);
        });
        if (_186_valueOrError0.IsFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            output = _186_valueOrError0.PropagateFailure(DecryptResponse._typeDescriptor(), Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        DecryptResponse _185_decryptResponse = _186_valueOrError0.Extract(DecryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _188_valueOrError1 = Outcome.Default();
        _188_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _185_decryptResponse.dtor_Plaintext().is_Some() && Objects.equals(BigInteger.valueOf(32L), BigInteger.valueOf(_185_decryptResponse.dtor_Plaintext().dtor_value().length())), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Decrypt: Key is not 32 bytes.")));
        if (_188_valueOrError1.IsFailure(Error._typeDescriptor())) {
            output = _188_valueOrError1.PropagateFailure(Error._typeDescriptor(), DecryptResponse._typeDescriptor());
            return output;
        }
        output = Result.create_Success(_185_decryptResponse);
        return output;
    }

    public String toString() {
        return "KMSKeystoreOperations._default";
    }
}

