/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsKmsKeyring_Compile.DecryptSingleEncryptedDataKey;
import AwsKmsKeyring_Compile.KmsGenerateAndWrapKeyMaterial;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import AwsKmsKeyring_Compile.KmsWrapKeyMaterial;
import AwsKmsKeyring_Compile.OnDecryptEncryptedDataKeyFilter;
import BoundedInts_Compile.uint8;
import Constants_Compile.__default;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    public AwsKmsIdentifier _awsKmsArn = null;
    private static final TypeDescriptor<AwsKmsKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out83 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out83;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out84 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out84;
    }

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _592_parsedAwsKmsId = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(awsKmsKey);
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._awsKmsArn = _592_parsedAwsKmsId.dtor_value();
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        EncryptionMaterials _593_materials = input.dtor_materials();
        AlgorithmSuiteInfo _594_suite = input.dtor_materials().dtor_algorithmSuite();
        Result<Object, Object> _596_valueOrError0 = Result.Default(DafnyMap.empty());
        _596_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_materials().dtor_encryptionContext());
        if (_596_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _596_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnyMap _595_stringifiedEncCtx = (DafnyMap)_596_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        KmsGenerateAndWrapKeyMaterial _nw1 = new KmsGenerateAndWrapKeyMaterial();
        _nw1.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsGenerateAndWrapKeyMaterial _597_kmsGenerateAndWrap = _nw1;
        KmsWrapKeyMaterial _nw2 = new KmsWrapKeyMaterial();
        _nw2.__ctor(this.client(), this.awsKmsKey(), this.grantTokens());
        KmsWrapKeyMaterial _598_kmsWrap = _nw2;
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Object> _600_valueOrError1 = Result.Default(WrapEdkMaterialOutput.Default(KmsWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<KmsWrapInfo>, Error> _out85 = EdkWrapping_Compile.__default.WrapEdkMaterial(KmsWrapInfo._typeDescriptor(), _593_materials, _598_kmsWrap, _597_kmsGenerateAndWrap);
        _600_valueOrError1 = _out85;
        if (_600_valueOrError1.IsFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            res = _600_valueOrError1.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        WrapEdkMaterialOutput<KmsWrapInfo> _599_wrapOutput = _600_valueOrError1.Extract(WrapEdkMaterialOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()), Error._typeDescriptor());
        DafnySequence<? extends Character> _601_kmsKeyArn = _599_wrapOutput.dtor_wrapInfo().dtor_kmsKeyArn();
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _602_symmetricSigningKeyList = _599_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_599_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        Result<DafnySequence<? extends Byte>, Object> _604_valueOrError2 = Result.Default(ValidUTF8Bytes.defaultValue());
        _604_valueOrError2 = UTF8.__default.Encode(_601_kmsKeyArn).MapFailure(ValidUTF8Bytes._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_604_valueOrError2.IsFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor())) {
            res = _604_valueOrError2.PropagateFailure(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence<? extends Byte> _603_providerInfo = _604_valueOrError2.Extract(ValidUTF8Bytes._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _605_valueOrError3 = Outcome.Default();
        _605_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), BigInteger.valueOf(_603_providerInfo.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT16__LIMIT()) < 0, Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS GenerateDataKey: Key ID too long.")));
        if (_605_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _605_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        EncryptedDataKey _606_edk = EncryptedDataKey.create(__default.PROVIDER__ID(), _603_providerInfo, _599_wrapOutput.dtor_wrappedMaterial());
        if (_599_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _608_valueOrError4 = null;
            _608_valueOrError4 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_593_materials, _599_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_606_edk}), _602_symmetricSigningKeyList);
            if (_608_valueOrError4.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _608_valueOrError4.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _607_result = _608_valueOrError4.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_607_result));
            return res;
        }
        if (_599_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _610_valueOrError5 = null;
            _610_valueOrError5 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_593_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_606_edk}), _602_symmetricSigningKeyList);
            if (_610_valueOrError5.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                res = _610_valueOrError5.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            EncryptionMaterials _609_result = _610_valueOrError5.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            res = Result.create_Success(OnEncryptOutput.create(_609_result));
            return res;
        }
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out87;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _611_materials = input.dtor_materials();
        AlgorithmSuiteInfo _612_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _613_valueOrError0 = Outcome.Default();
        _613_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_611_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_613_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _613_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        OnDecryptEncryptedDataKeyFilter _nw3 = new OnDecryptEncryptedDataKeyFilter();
        _nw3.__ctor(this.awsKmsKey());
        OnDecryptEncryptedDataKeyFilter _614_filter = _nw3;
        Result<Object, Object> _616_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out86 = Actions_Compile.__default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _614_filter, input.dtor_encryptedDataKeys());
        _616_valueOrError1 = _out86;
        if (_616_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _616_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _615_edksToAttempt = (DafnySequence)_616_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_615_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _618_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _618_valueOrError2 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_618_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _618_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _617_errorMessage = (DafnySequence)_618_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_617_errorMessage));
            return res;
        }
        DecryptSingleEncryptedDataKey _nw4 = new DecryptSingleEncryptedDataKey();
        _nw4.__ctor(_611_materials, this.client(), this.awsKmsKey(), this.grantTokens());
        DecryptSingleEncryptedDataKey _619_decryptClosure = _nw4;
        Result<DecryptionMaterials, DafnySequence<Error>> _620_outcome = _out87 = Actions_Compile.__default.ReduceToSuccess(EncryptedDataKey._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _619_decryptClosure, _615_edksToAttempt);
        Result<DecryptionMaterials, Error> _622_valueOrError3 = null;
        _622_valueOrError3 = _620_outcome.MapFailure(SealedDecryptionMaterials._typeDescriptor(), (TypeDescriptor<DafnySequence<Error>>)DafnySequence._typeDescriptor(Error._typeDescriptor()), Error._typeDescriptor(), _623_errors_boxed0 -> {
            DafnySequence _623_errors = _623_errors_boxed0;
            return Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_623_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        });
        if (_622_valueOrError3.IsFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
            res = _622_valueOrError3.PropagateFailure(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DecryptionMaterials _621_SealedDecryptionMaterials = _622_valueOrError3.Extract(SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(OnDecryptOutput.create(_621_SealedDecryptionMaterials));
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public AwsKmsIdentifier awsKmsArn() {
        return this._awsKmsArn;
    }

    public static TypeDescriptor<AwsKmsKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.AwsKmsKeyring";
    }
}

