/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsHierarchicalKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsHierarchicalKeyring_Compile.HierarchyUnwrapInfo;
import AwsKmsHierarchicalKeyring_Compile.KmsHierarchyUnwrapKeyMaterial;
import AwsKmsHierarchicalKeyring_Compile.__default;
import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.keystore.internaldafny.types.BranchKeyMaterials;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionInput;
import software.amazon.cryptography.keystore.internaldafny.types.GetBranchKeyVersionOutput;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.ICryptographicMaterialsCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.Materials;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.DigestAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.DigestInput;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.internaldafny.types.IAwsCryptographicPrimitivesClient;

public class DecryptSingleEncryptedDataKey
implements ActionWithResult<EncryptedDataKey, DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>,
Action<EncryptedDataKey, Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error>> {
    public DecryptionMaterials _materials = null;
    public IKeyStoreClient _keyStore = null;
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Character> _branchKeyId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public long _ttlSeconds = 0L;
    public ICryptographicMaterialsCache _cache = null;
    private static final TypeDescriptor<DecryptSingleEncryptedDataKey> _TYPE = TypeDescriptor.referenceWithInitializer(DecryptSingleEncryptedDataKey.class, () -> null);

    public void __ctor(DecryptionMaterials materials, IKeyStoreClient keyStore, AtomicPrimitivesClient cryptoPrimitives, DafnySequence<? extends Character> branchKeyId, long ttlSeconds, ICryptographicMaterialsCache cache) {
        this._materials = materials;
        this._keyStore = keyStore;
        this._cryptoPrimitives = cryptoPrimitives;
        this._branchKeyId = branchKeyId;
        this._ttlSeconds = ttlSeconds;
        this._cache = cache;
    }

    @Override
    public Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> Invoke(EncryptedDataKey edk) {
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out169;
        Result<AtomicPrimitivesClient, Error> _out168;
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> res = null;
        Outcome<Object> _968_valueOrError0 = Outcome.Default();
        _968_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received invalid EDK provider info for Hierarchical Keyring")));
        if (_968_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _968_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        AlgorithmSuiteInfo _969_suite = this.materials().dtor_algorithmSuite();
        DafnySequence<? extends Byte> _970_keyProviderId = edk.dtor_keyProviderId();
        DafnySequence<? extends Byte> _971_branchKeyIdUtf8 = edk.dtor_keyProviderInfo();
        DafnySequence<? extends Byte> _972_ciphertext = edk.dtor_ciphertext();
        Result<Object, Object> _974_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _974_valueOrError1 = EdkWrapping_Compile.__default.GetProviderWrappedMaterial(_972_ciphertext, _969_suite);
        if (_974_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _974_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _973_providerWrappedMaterial = (DafnySequence)_974_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Outcome<Object> _975_valueOrError2 = Outcome.Default();
        _975_valueOrError2 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_973_providerWrappedMaterial.length()).compareTo(BigInteger.valueOf(__default.EDK__CIPHERTEXT__VERSION__INDEX())) >= 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Received EDK Ciphertext of incorrect length.")));
        if (_975_valueOrError2.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _975_valueOrError2.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _976_branchKeyVersionUuid = _973_providerWrappedMaterial.subsequence(__default.EDK__CIPHERTEXT__BRANCH__KEY__VERSION__INDEX(), __default.EDK__CIPHERTEXT__VERSION__INDEX());
        Result<Object, Object> _978_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _978_valueOrError3 = UUID.__default.FromByteArray((DafnySequence<? extends Byte>)_976_branchKeyVersionUuid).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_978_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _978_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _977_version = (DafnySequence)_978_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _980_valueOrError4 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out166 = this.GetVersionCacheId(_971_branchKeyIdUtf8, (DafnySequence<? extends Character>)_977_version, this.cryptoPrimitives());
        _980_valueOrError4 = _out166;
        if (_980_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _980_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _979_cacheId = (DafnySequence)_980_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<BranchKeyMaterials, Object> _982_valueOrError5 = Result.Default(BranchKeyMaterials.Default());
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out167 = this.GetHierarchicalMaterialsVersion(this.branchKeyId(), _971_branchKeyIdUtf8, (DafnySequence<? extends Character>)_977_version, (DafnySequence<? extends Byte>)_979_cacheId);
        _982_valueOrError5 = _out167;
        if (_982_valueOrError5.IsFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _982_valueOrError5.PropagateFailure(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        BranchKeyMaterials _981_hierarchicalMaterials = _982_valueOrError5.Extract(BranchKeyMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        DafnySequence<? extends Byte> _983_branchKey = _981_hierarchicalMaterials.dtor_branchKey();
        DafnySequence<? extends Byte> _984_branchKeyVersion = _981_hierarchicalMaterials.dtor_branchKeyVersion();
        Result<Object, Object> _986_valueOrError6 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _986_valueOrError6 = UTF8.__default.Decode(_984_branchKeyVersion).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_986_valueOrError6.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _986_valueOrError6.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _985_branchKeyVersionAsString = (DafnySequence)_986_valueOrError6.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<Object, Object> _988_valueOrError7 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _988_valueOrError7 = UUID.__default.ToByteArray((DafnySequence<? extends Character>)_985_branchKeyVersionAsString).MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_988_valueOrError7.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _988_valueOrError7.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DafnySequence _987_branchKeyVersionAsBytes = (DafnySequence)_988_valueOrError7.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<AtomicPrimitivesClient, Error> _989_maybeCrypto = _out168 = software.amazon.cryptography.primitives.internaldafny.__default.AtomicPrimitives(software.amazon.cryptography.primitives.internaldafny.__default.DefaultCryptoConfig());
        Result<AtomicPrimitivesClient, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _991_valueOrError8 = null;
        _991_valueOrError8 = _989_maybeCrypto.MapFailure(AtomicPrimitivesClient._typeDescriptor(), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _992_e_boxed0 -> {
            Error _992_e = _992_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_992_e);
        });
        if (_991_valueOrError8.IsFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _991_valueOrError8.PropagateFailure(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        IAwsCryptographicPrimitivesClient _990_cryptoPrimitivesX = _991_valueOrError8.Extract(AtomicPrimitivesClient._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        AtomicPrimitivesClient _993_cryptoPrimitives = (AtomicPrimitivesClient)_990_cryptoPrimitivesX;
        KmsHierarchyUnwrapKeyMaterial _nw37 = new KmsHierarchyUnwrapKeyMaterial();
        _nw37.__ctor(_983_branchKey, _971_branchKeyIdUtf8, (DafnySequence<? extends Byte>)_987_branchKeyVersionAsBytes, _993_cryptoPrimitives);
        KmsHierarchyUnwrapKeyMaterial _994_kmsHierarchyUnwrap = _nw37;
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _995_unwrapOutputRes = _out169 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(HierarchyUnwrapInfo._typeDescriptor(), edk.dtor_ciphertext(), this.materials(), _994_kmsHierarchyUnwrap);
        Result<UnwrapEdkMaterialOutput<HierarchyUnwrapInfo>, Object> _997_valueOrError9 = Result.Default(UnwrapEdkMaterialOutput.Default(HierarchyUnwrapInfo.Default()));
        _997_valueOrError9 = _995_unwrapOutputRes;
        if (_997_valueOrError9.IsFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _997_valueOrError9.PropagateFailure(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        UnwrapEdkMaterialOutput<HierarchyUnwrapInfo> _996_unwrapOutput = _997_valueOrError9.Extract(UnwrapEdkMaterialOutput._typeDescriptor(HierarchyUnwrapInfo._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        Result<DecryptionMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _999_valueOrError10 = null;
        _999_valueOrError10 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(this.materials(), _996_unwrapOutput.dtor_plaintextDataKey(), _996_unwrapOutput.dtor_symmetricSigningKey());
        if (_999_valueOrError10.IsFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            res = _999_valueOrError10.PropagateFailure(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor());
            return res;
        }
        DecryptionMaterials _998_result = _999_valueOrError10.Extract(DecryptionMaterials._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        res = Result.create_Success(_998_result);
        return res;
    }

    public Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetVersionCacheId(DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> branchKeyVersion, AtomicPrimitivesClient cryptoPrimitives) {
        Result<DafnySequence<? extends Byte>, Error> _out170;
        Result<DafnySequence<? extends Byte>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> cacheId = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        Outcome<Object> _1000_valueOrError0 = Outcome.Default();
        _1000_valueOrError0 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).is_Success() && (Boolean)Helpers.Let(UTF8.__default.Decode(branchKeyIdUtf8).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError).dtor_value(), boxed42 -> {
            DafnySequence _pat_let21_0 = boxed42;
            return (boolean)((Boolean)Helpers.Let((Object)_pat_let21_0, boxed43 -> {
                DafnySequence _1001_branchKeyId = boxed43;
                return BigInteger.valueOf(_1001_branchKeyId.length()).signum() != -1 && BigInteger.valueOf(_1001_branchKeyId.length()).compareTo(StandardLibrary_mUInt_Compile.__default.UINT32__LIMIT()) < 0;
            }));
        }) != false, __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Branch Key ID Length")));
        if (_1000_valueOrError0.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1000_valueOrError0.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Character> _1002_branchKeyId = UTF8.__default.Decode(branchKeyIdUtf8).dtor_value();
        DafnySequence<? extends Byte> _1003_lenBranchKey = StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(_1002_branchKeyId.cardinalityInt());
        Outcome<Object> _1004_valueOrError1 = Outcome.Default();
        _1004_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), UTF8.__default.IsASCIIString(branchKeyVersion), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unable to represent as an ASCII string.")));
        if (_1004_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1004_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence<? extends Byte> _1005_versionBytes = UTF8.__default.EncodeAscii(branchKeyVersion);
        DafnySequence _1006_identifier = DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(_1003_lenBranchKey, branchKeyIdUtf8), (DafnySequence)DafnySequence.of((byte[])new byte[]{0})), _1005_versionBytes);
        DigestInput _1007_identifierDigestInput = DigestInput.create(DigestAlgorithm.create_SHA__512(), (DafnySequence<? extends Byte>)_1006_identifier);
        Result<DafnySequence<? extends Byte>, Error> _1008_maybeCacheDigest = _out170 = Digest_Compile.__default.Digest(_1007_identifierDigestInput);
        Result<Object, Object> _1010_valueOrError2 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1010_valueOrError2 = _1008_maybeCacheDigest.MapFailure((TypeDescriptor<DafnySequence<? extends Byte>>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1011_e_boxed0 -> {
            Error _1011_e = _1011_e_boxed0;
            return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyPrimitives(_1011_e);
        });
        if (_1010_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            cacheId = _1010_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), DafnySequence._typeDescriptor(uint8._typeDescriptor()));
            return cacheId;
        }
        DafnySequence _1009_cacheDigest = (DafnySequence)_1010_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
        cacheId = Result.create_Success(_1009_cacheDigest.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(32L))));
        return cacheId;
    }

    public Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> GetHierarchicalMaterialsVersion(DafnySequence<? extends Character> branchKeyId, DafnySequence<? extends Byte> branchKeyIdUtf8, DafnySequence<? extends Character> version, DafnySequence<? extends Byte> cacheId) {
        Result<BranchKeyMaterials, software.amazon.cryptography.materialproviders.internaldafny.types.Error> material = Result.Default(BranchKeyMaterials.Default());
        GetCacheEntryInput _1012_getCacheInput = GetCacheEntryInput.create(cacheId, Option.create_None());
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out171 = __default.getEntry(this.cache(), _1012_getCacheInput);
        Result<GetCacheEntryOutput, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _1013_getCacheOutput = _out171;
        if (_1013_getCacheOutput.is_Failure()) {
            long _out173;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _out172;
            Result<GetBranchKeyVersionOutput, software.amazon.cryptography.keystore.internaldafny.types.Error> _1014_maybeGetBranchKeyVersionOutput = _out172 = this.keyStore().GetBranchKeyVersion(GetBranchKeyVersionInput.create(branchKeyId, version));
            Result<GetBranchKeyVersionOutput, Object> _1016_valueOrError0 = Result.Default(GetBranchKeyVersionOutput.Default());
            _1016_valueOrError0 = _1014_maybeGetBranchKeyVersionOutput.MapFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.keystore.internaldafny.types.Error._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1017_e_boxed0 -> {
                software.amazon.cryptography.keystore.internaldafny.types.Error _1017_e = _1017_e_boxed0;
                return software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographyKeyStore(_1017_e);
            });
            if (_1016_valueOrError0.IsFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1016_valueOrError0.PropagateFailure(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            GetBranchKeyVersionOutput _1015_getBranchKeyVersionOutput = _1016_valueOrError0.Extract(GetBranchKeyVersionOutput._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            BranchKeyMaterials _1018_branchKeyMaterials = _1015_getBranchKeyVersionOutput.dtor_branchKeyMaterials();
            long _1019_now = _out173 = Time.__default.CurrentRelativeTime().longValue();
            Outcome<Object> _1020_valueOrError1 = Outcome.Default();
            _1020_valueOrError1 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BigInteger.valueOf(_1019_now).add(BigInteger.valueOf(this.ttlSeconds())).compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) < 0, software.amazon.cryptography.materialproviders.internaldafny.types.Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"INT64 Overflow when putting cache entry.")));
            if (_1020_valueOrError1.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1020_valueOrError1.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            PutCacheEntryInput _1021_putCacheEntryInput = PutCacheEntryInput.create(cacheId, Materials.create_BranchKey(_1018_branchKeyMaterials), _1019_now, this.ttlSeconds() + _1019_now, Option.create_None(), Option.create_None());
            Result<Tuple0, Object> _1023_valueOrError2 = Result.Default(Tuple0.Default());
            Result<Tuple0, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _out174 = __default.putEntry(this.cache(), _1021_putCacheEntryInput);
            _1023_valueOrError2 = _out174;
            if (_1023_valueOrError2.IsFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
                material = _1023_valueOrError2.PropagateFailure((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
                return material;
            }
            Tuple0 _1022___v1 = _1023_valueOrError2.Extract((TypeDescriptor<Tuple0>)Tuple0._typeDescriptor(), software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor());
            material = Result.create_Success(_1018_branchKeyMaterials);
            return material;
        }
        Outcome<Object> _1024_valueOrError3 = Outcome.Default();
        _1024_valueOrError3 = Wrappers_Compile.__default.Need(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), _1013_getCacheOutput.dtor_value().dtor_materials().is_BranchKey() && Objects.equals(_1013_getCacheOutput.dtor_value().dtor_materials(), Materials.create_BranchKey(_1013_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey())), __default.E((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Material Type.")));
        if (_1024_valueOrError3.IsFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor())) {
            material = _1024_valueOrError3.PropagateFailure(software.amazon.cryptography.materialproviders.internaldafny.types.Error._typeDescriptor(), BranchKeyMaterials._typeDescriptor());
            return material;
        }
        material = Result.create_Success(_1013_getCacheOutput.dtor_value().dtor_materials().dtor_BranchKey());
        return material;
    }

    public DecryptionMaterials materials() {
        return this._materials;
    }

    public IKeyStoreClient keyStore() {
        return this._keyStore;
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Character> branchKeyId() {
        return this._branchKeyId;
    }

    public long ttlSeconds() {
        return this._ttlSeconds;
    }

    public ICryptographicMaterialsCache cache() {
        return this._cache;
    }

    public static TypeDescriptor<DecryptSingleEncryptedDataKey> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsHierarchicalKeyring.DecryptSingleEncryptedDataKey";
    }
}

