/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.keystore.internaldafny;

import AwsArnParsing_Compile.AwsKmsIdentifier;
import AwsCryptographyKeyStoreOperations_Compile.Config;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.keystore.internaldafny.KeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.Error;
import software.amazon.cryptography.keystore.internaldafny.types.IKeyStoreClient;
import software.amazon.cryptography.keystore.internaldafny.types.KMSConfiguration;
import software.amazon.cryptography.keystore.internaldafny.types.KeyStoreConfig;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types._Companion_IDynamoDBClient;
import software.amazon.cryptography.services.dynamodb.internaldafny.types.__default;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;
import software.amazon.cryptography.services.kms.internaldafny.types._Companion_IKMSClient;

public abstract class _ExternBase___default {
    public static KeyStoreConfig DefaultKeyStoreConfig() {
        return KeyStoreConfig.create((DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), KMSConfiguration.create_kmsKeyArn((DafnySequence<? extends Character>)DafnySequence.asString((String)"1234abcd-12ab-34cd-56ef-1234567890ab")), (DafnySequence<? extends Character>)DafnySequence.asString((String)"None"), Option.create_None(), Option.create_None(), Option.create_None(), Option.create_None());
    }

    public static Result<KeyStoreClient, Error> KeyStore(KeyStoreConfig config) {
        Result<KeyStoreClient, Error> res = null;
        Outcome<Object> _296_valueOrError0 = Outcome.Default();
        _296_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__KeyIdType(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration())) && AwsArnParsing_Compile.__default.ParseAwsKmsArn(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration())).is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS Key Arn")));
        if (_296_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _296_valueOrError0.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        Result<DafnySequence<? extends DafnySequence<? extends Character>>, software.amazon.cryptography.materialproviders.internaldafny.types.Error> _297_grantTokens = AwsKmsUtils_Compile.__default.GetValidGrantTokens(config.dtor_grantTokens());
        Outcome<Object> _298_valueOrError1 = Outcome.Default();
        _298_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _297_grantTokens.is_Success(), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"CreateKey received invalid grant tokens")));
        if (_298_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _298_valueOrError1.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        DafnySequence _299_keyStoreId = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
        if (config.dtor_id().is_Some()) {
            _299_keyStoreId = config.dtor_id().dtor_value();
        } else {
            DafnySequence _301_uuid;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _out44;
            Result<DafnySequence<? extends Character>, DafnySequence<? extends Character>> _300_maybeUuid = _out44 = UUID.__default.GenerateUUID();
            Result<Object, Object> _302_valueOrError2 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _302_valueOrError2 = _300_maybeUuid.MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _303_e_boxed0 -> {
                DafnySequence _303_e = _303_e_boxed0;
                return Error.create_KeyStoreException((DafnySequence<? extends Character>)_303_e);
            });
            if (_302_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _302_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _299_keyStoreId = _301_uuid = (DafnySequence)_302_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        }
        IKMSClient _304_kmsClient = null;
        IDynamoDBClient _305_ddbClient = null;
        Result<AwsKmsIdentifier, DafnySequence<? extends Character>> _306_keyArn = AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(KMSKeystoreOperations_Compile.__default.GetKeyId(config.dtor_kmsConfiguration()));
        Option<DafnySequence<? extends Character>> _307_kmsRegion = AwsArnParsing_Compile.__default.GetRegion(_306_keyArn.dtor_value());
        if (config.dtor_kmsClient().is_None()) {
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out45;
            Result<IKMSClient, software.amazon.cryptography.services.kms.internaldafny.types.Error> _308_maybeKmsClient = _out45 = software.amazon.cryptography.services.kms.internaldafny.__default.KMSClientForRegion(_307_kmsRegion.dtor_value());
            Result<IKMSClient, Error> _309_valueOrError3 = null;
            _309_valueOrError3 = _308_maybeKmsClient.MapFailure(_Companion_IKMSClient._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _310_e_boxed0 -> {
                software.amazon.cryptography.services.kms.internaldafny.types.Error _310_e = _310_e_boxed0;
                return Error.create_ComAmazonawsKms(_310_e);
            });
            if (_309_valueOrError3.IsFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _309_valueOrError3.PropagateFailure(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _304_kmsClient = _309_valueOrError3.Extract(_Companion_IKMSClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _304_kmsClient = config.dtor_kmsClient().dtor_value();
        }
        if (config.dtor_ddbClient().is_None()) {
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _out46;
            Result<IDynamoDBClient, software.amazon.cryptography.services.dynamodb.internaldafny.types.Error> _311_maybeDdbClient = _out46 = software.amazon.cryptography.services.dynamodb.internaldafny.__default.DDBClientForRegion(_307_kmsRegion.dtor_value());
            Result<IDynamoDBClient, Error> _312_valueOrError4 = null;
            _312_valueOrError4 = _311_maybeDdbClient.MapFailure(_Companion_IDynamoDBClient._typeDescriptor(), software.amazon.cryptography.services.dynamodb.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _313_e_boxed0 -> {
                software.amazon.cryptography.services.dynamodb.internaldafny.types.Error _313_e = _313_e_boxed0;
                return Error.create_ComAmazonawsDynamodb(_313_e);
            });
            if (_312_valueOrError4.IsFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor())) {
                res = _312_valueOrError4.PropagateFailure(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
                return res;
            }
            _305_ddbClient = _312_valueOrError4.Extract(_Companion_IDynamoDBClient._typeDescriptor(), Error._typeDescriptor());
        } else {
            _305_ddbClient = config.dtor_ddbClient().dtor_value();
        }
        Outcome<Object> _314_valueOrError5 = Outcome.Default();
        _314_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), __default.IsValid__TableName(config.dtor_ddbTableName()), Error.create_KeyStoreException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Amazon DynamoDB Table Name")));
        if (_314_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _314_valueOrError5.PropagateFailure(Error._typeDescriptor(), KeyStoreClient._typeDescriptor());
            return res;
        }
        KeyStoreClient _nw0 = new KeyStoreClient();
        _nw0.__ctor(Config.create((DafnySequence<? extends Character>)_299_keyStoreId, config.dtor_ddbTableName(), config.dtor_logicalKeyStoreName(), config.dtor_kmsConfiguration(), _297_grantTokens.dtor_value(), _304_kmsClient, _305_ddbClient));
        KeyStoreClient _315_client = _nw0;
        res = Result.create_Success(_315_client);
        return res;
    }

    public static Result<IKeyStoreClient, Error> CreateSuccessOfClient(IKeyStoreClient client) {
        return Result.create_Success(client);
    }

    public static Result<IKeyStoreClient, Error> CreateFailureOfError(Error error) {
        return Result.create_Failure(error);
    }

    public String toString() {
        return "KeyStore._default";
    }
}

