/*
 * Decompiled with CFR 0.152.
 */
package StormTracker_Compile;

import BoundedInts_Compile.uint8;
import DafnyLibraries.MutableMap;
import LocalCMC_Compile.LocalCMC;
import StormTracker_Compile.CacheState;
import Time.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.DafnySet;
import dafny.Helpers;
import dafny.Tuple0;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.CountingNumber;
import software.amazon.cryptography.materialproviders.internaldafny.types.DeleteCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.GetCacheEntryOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.PositiveLong;
import software.amazon.cryptography.materialproviders.internaldafny.types.PutCacheEntryInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.StormTrackingCache;
import software.amazon.cryptography.materialproviders.internaldafny.types.UpdateUsageMetadataInput;

public class StormTracker {
    public LocalCMC wrapped = null;
    public MutableMap<DafnySequence<? extends Byte>, Long> inFlight = null;
    public long gracePeriod = 0L;
    public long graceInterval = 0L;
    public long fanOut = 0L;
    public long inFlightTTL = 0L;
    public long lastPrune = 0L;
    public long sleepMilli = 0L;
    private static final TypeDescriptor<StormTracker> _TYPE = TypeDescriptor.referenceWithInitializer(StormTracker.class, () -> null);

    public void __ctor(StormTrackingCache cache) {
        LocalCMC _nw31 = new LocalCMC();
        _nw31.__ctor(BigInteger.valueOf(cache.dtor_entryCapacity()), BigInteger.valueOf(cache.dtor_entryPruningTailSize().UnwrapOr(CountingNumber._typeDescriptor(), 1).intValue()));
        this.wrapped = _nw31;
        MutableMap _nw32 = new MutableMap(DafnySequence._typeDescriptor(uint8._typeDescriptor()), PositiveLong._typeDescriptor());
        this.inFlight = _nw32;
        this.gracePeriod = cache.dtor_gracePeriod();
        this.graceInterval = cache.dtor_graceInterval();
        this.fanOut = cache.dtor_fanOut();
        this.inFlightTTL = cache.dtor_inFlightTTL();
        this.sleepMilli = cache.dtor_sleepMilli();
        this.lastPrune = 0L;
    }

    public long InFlightSize() {
        BigInteger _836_x = this.inFlight.Size();
        if (_836_x.compareTo(StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT()) <= 0) {
            return _836_x.longValue();
        }
        return StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue();
    }

    public boolean FanOutReached(long now) {
        boolean res = false;
        this.PruneInFlight(now);
        res = this.fanOut <= this.InFlightSize();
        return res;
    }

    public long AddLong(long x, long y) {
        if (x < StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue() - y) {
            return x + y;
        }
        return StandardLibrary_mUInt_Compile.__default.INT64__MAX__LIMIT().longValue();
    }

    public CacheState CheckInFlight(DafnySequence<? extends Byte> identifier, GetCacheEntryOutput result, long now) {
        CacheState _out130;
        CacheState output = CacheState.Default();
        boolean _out129 = this.FanOutReached(now);
        boolean _837_fanOutReached = _out129;
        if (_837_fanOutReached) {
            output = CacheState.create_Full(result);
            return output;
        }
        if (result.dtor_expiryTime() > now) {
            long _838_entry;
            if (now < result.dtor_expiryTime() - this.gracePeriod) {
                output = CacheState.create_Full(result);
                return output;
            }
            if (this.inFlight.HasKey(identifier) && this.AddLong(_838_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval) > now) {
                output = CacheState.create_Full(result);
                return output;
            }
            this.inFlight.Put(identifier, now);
            output = CacheState.create_EmptyFetch();
            return output;
        }
        output = _out130 = this.CheckNewEntry(identifier, now);
        return output;
    }

    public void PruneInFlight(long now) {
        if (this.fanOut > this.InFlightSize()) {
            return;
        }
        if (this.lastPrune == now) {
            return;
        }
        this.lastPrune = now;
        DafnySet<DafnySequence<? extends Byte>> _839_keySet = this.inFlight.Keys();
        DafnySequence<DafnySequence<? extends Byte>> _840_keys = SortedSets.__default.SetToSequence(DafnySequence._typeDescriptor(uint8._typeDescriptor()), _839_keySet);
        BigInteger _hi7 = BigInteger.valueOf(_840_keys.length());
        BigInteger _841_i = BigInteger.ZERO;
        while (_841_i.compareTo(_hi7) < 0) {
            long _842_v = this.inFlight.Select((DafnySequence<? extends Byte>)((DafnySequence)_840_keys.select(Helpers.toInt((BigInteger)_841_i))));
            if (now >= this.AddLong(_842_v, this.inFlightTTL)) {
                this.inFlight.Remove((DafnySequence<? extends Byte>)((DafnySequence)_840_keys.select(Helpers.toInt((BigInteger)_841_i))));
            }
            _841_i = _841_i.add(BigInteger.ONE);
        }
    }

    public CacheState CheckNewEntry(DafnySequence<? extends Byte> identifier, long now) {
        long _844_entry;
        CacheState output = CacheState.Default();
        boolean _out131 = this.FanOutReached(now);
        boolean _843_fanOutReached = _out131;
        if (_843_fanOutReached) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        if (this.inFlight.HasKey(identifier) && this.AddLong(_844_entry = this.inFlight.Select(identifier).longValue(), this.graceInterval) > now) {
            output = CacheState.create_EmptyWait();
            return output;
        }
        this.inFlight.Put(identifier, now);
        output = CacheState.create_EmptyFetch();
        return output;
    }

    public Result<CacheState, Error> GetFromCacheWithTime(GetCacheEntryInput input, long now) {
        Result<CacheState, Error> output = Result.Default(CacheState.Default());
        Result<GetCacheEntryOutput, Error> _out132 = this.wrapped.GetCacheEntryWithTime(input, now);
        Result<GetCacheEntryOutput, Error> _845_result = _out132;
        if (_845_result.is_Success()) {
            CacheState _out133;
            CacheState _846_newResult = _out133 = this.CheckInFlight(input.dtor_identifier(), _845_result.dtor_value(), now);
            output = Result.create_Success(_846_newResult);
            return output;
        }
        if (_845_result.dtor_error().is_EntryDoesNotExist()) {
            CacheState _out134;
            CacheState _847_newResult = _out134 = this.CheckNewEntry(input.dtor_identifier(), now);
            output = Result.create_Success(_847_newResult);
            return output;
        }
        output = Result.create_Failure(_845_result.dtor_error());
        return output;
    }

    public Result<CacheState, Error> GetFromCache(GetCacheEntryInput input) {
        long _out135;
        Result<CacheState, Error> output = Result.Default(CacheState.Default());
        long _848_now = _out135 = __default.CurrentRelativeTime().longValue();
        Result<CacheState, Error> _out136 = this.GetFromCacheWithTime(input, _848_now);
        output = _out136;
        return output;
    }

    public Result<GetCacheEntryOutput, Error> GetCacheEntry(GetCacheEntryInput input) {
        Result<GetCacheEntryOutput, Error> output = null;
        Result<CacheState, Error> _out137 = this.GetFromCache(input);
        Result<CacheState, Error> _849_result = _out137;
        if (_849_result.is_Failure()) {
            output = Result.create_Failure(_849_result.dtor_error());
            return output;
        }
        if (_849_result.dtor_value().is_Full()) {
            output = Result.create_Success(_849_result.dtor_value().dtor_data());
            return output;
        }
        output = Result.create_Failure(Error.create_EntryDoesNotExist((DafnySequence<? extends Character>)DafnySequence.asString((String)"Entry does not exist")));
        return output;
    }

    public Result<Tuple0, Error> PutCacheEntry(PutCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out138 = this.wrapped.PutCacheEntry_k(input);
        output = _out138;
        return output;
    }

    public Result<Tuple0, Error> DeleteCacheEntry(DeleteCacheEntryInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        this.inFlight.Remove(input.dtor_identifier());
        Result<Tuple0, Error> _out139 = this.wrapped.DeleteCacheEntry_k(input);
        output = _out139;
        return output;
    }

    public Result<Tuple0, Error> UpdateUsageMetadata(UpdateUsageMetadataInput input) {
        Result<Tuple0, Error> output = Result.Default(Tuple0.Default());
        Result<Tuple0, Error> _out140 = this.wrapped.UpdateUsageMetadata_k(input);
        output = _out140;
        return output;
    }

    public static TypeDescriptor<StormTracker> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "StormTracker.StormTracker";
    }
}

