/*
 * Decompiled with CFR 0.152.
 */
package Signature;

import Dafny.Aws.Cryptography.Primitives.Types.InternalResult;
import Signature.ECDSA;
import Signature.SignatureAlgorithm;
import Signature._ExternBase___default;
import dafny.Array;
import dafny.DafnySequence;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.Objects;
import software.amazon.cryptography.primitives.ToDafny;
import software.amazon.cryptography.primitives.internaldafny.types.ECDSASignatureAlgorithm;
import software.amazon.cryptography.primitives.internaldafny.types.Error;
import software.amazon.cryptography.primitives.model.AwsCryptographicPrimitivesError;
import software.amazon.cryptography.primitives.model.OpaqueError;

class PublicKeyUtils {
    PublicKeyUtils() {
    }

    static byte[] encodeAndCompressPublicKey(PublicKey key, ECDSASignatureAlgorithm dtor_signatureAlgorithm) {
        Objects.requireNonNull(key, "key is required");
        if (!(key instanceof ECPublicKey)) {
            throw new IllegalArgumentException("key must be an instance of ECPublicKey");
        }
        BigInteger x = ((ECPublicKey)key).getW().getAffineX();
        BigInteger y = ((ECPublicKey)key).getW().getAffineY();
        BigInteger compressedY = y.mod(ECDSA.TWO).equals(BigInteger.ZERO) ? ECDSA.TWO : ECDSA.THREE;
        int xFieldSize = _ExternBase___default.FieldSize(dtor_signatureAlgorithm).intValueExact() - 1;
        byte[] xBytes = PublicKeyUtils.encodeAndCompressPublicKeyX(x, xFieldSize);
        byte[] compressedKey = new byte[xBytes.length + 1];
        System.arraycopy(xBytes, 0, compressedKey, 1, xBytes.length);
        compressedKey[0] = compressedY.byteValue();
        return compressedKey;
    }

    static byte[] encodeAndCompressPublicKeyX(BigInteger bigInteger, int length) {
        byte[] rawBytes = bigInteger.toByteArray();
        if (rawBytes.length == length) {
            return rawBytes;
        }
        if (rawBytes.length == length + 1 && rawBytes[0] == 0) {
            return Arrays.copyOfRange(rawBytes, 1, rawBytes.length);
        }
        if (rawBytes.length > length) {
            throw new IllegalArgumentException("Length must be at least as long as the BigInteger byte array without the sign byte");
        }
        byte[] paddedResult = new byte[length];
        System.arraycopy(rawBytes, 0, paddedResult, length - rawBytes.length, rawBytes.length);
        return paddedResult;
    }

    static InternalResult<ECPublicKey, Error> decodePublicKey(SignatureAlgorithm algorithm, DafnySequence<? extends Byte> dtor_verificationKey) {
        ECPublicKey publicKey;
        try {
            ECParameterSpec ecParameterSpec = SignatureAlgorithm.ecParameterSpec(algorithm);
            byte[] keyAsBytes = (byte[])Array.unwrap((Array)dtor_verificationKey.toArray());
            ECPublicKeySpec publicKeySpec = new ECPublicKeySpec(PublicKeyUtils.byteArrayToECPoint(keyAsBytes, ecParameterSpec), ecParameterSpec);
            publicKey = (ECPublicKey)KeyFactory.getInstance("EC").generatePublic(publicKeySpec);
        }
        catch (ECDecodingException ex) {
            return InternalResult.failure(ToDafny.Error(AwsCryptographicPrimitivesError.builder().message(String.format("Could not decode Elliptic Curve point due to: %s.", ex.getMessage())).cause(ex).build()));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException e) {
            return InternalResult.failure(ToDafny.Error(OpaqueError.builder().obj(e).message(e.getMessage()).cause(e).build()));
        }
        return InternalResult.success(publicKey);
    }

    static ECPoint byteArrayToECPoint(byte[] keyAsBytes, ECParameterSpec ecParameterSpec) throws ECDecodingException {
        BigInteger y;
        BigInteger yOrder;
        BigInteger x = new BigInteger(1, Arrays.copyOfRange(keyAsBytes, 1, keyAsBytes.length));
        byte compressedY = keyAsBytes[0];
        if (compressedY == ECDSA.TWO.byteValue()) {
            yOrder = BigInteger.ZERO;
        } else if (compressedY == ECDSA.THREE.byteValue()) {
            yOrder = BigInteger.ONE;
        } else {
            throw new ECDecodingException("Compressed y value was invalid");
        }
        BigInteger p = ((ECFieldFp)ecParameterSpec.getCurve().getField()).getP();
        BigInteger a = ecParameterSpec.getCurve().getA();
        BigInteger b = ecParameterSpec.getCurve().getB();
        BigInteger alpha = x.modPow(ECDSA.THREE, p).add(a.multiply(x).mod(p)).add(b).mod(p);
        if (!p.mod(ECDSA.FOUR).equals(ECDSA.THREE)) {
            throw new ECDecodingException("Curve not supported at this time");
        }
        BigInteger beta = alpha.modPow(p.add(BigInteger.ONE).divide(ECDSA.FOUR), p);
        BigInteger bigInteger = y = beta.mod(ECDSA.TWO).equals(yOrder) ? beta : p.subtract(beta);
        if (!alpha.equals(y.modPow(ECDSA.TWO, p))) {
            throw new ECDecodingException("Y was invalid");
        }
        return new ECPoint(x, y);
    }

    static class ECDecodingException
    extends RuntimeException {
        ECDecodingException(String message) {
            super(message);
        }
    }
}

