/*
 * Decompiled with CFR 0.152.
 */
package RawAESKeyring_Compile;

import BoundedInts_Compile.uint8;
import EdkWrapping_Compile.UnwrapEdkMaterialOutput;
import EdkWrapping_Compile.WrapEdkMaterialOutput;
import Keyring_Compile.VerifiableInterface;
import RawAESKeyring_Compile.AesGenerateAndWrapKeyMaterial;
import RawAESKeyring_Compile.AesUnwrapInfo;
import RawAESKeyring_Compile.AesUnwrapKeyMaterial;
import RawAESKeyring_Compile.AesWrapInfo;
import RawAESKeyring_Compile.AesWrapKeyMaterial;
import RawAESKeyring_Compile.__default;
import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.primitives.internaldafny.AtomicPrimitivesClient;
import software.amazon.cryptography.primitives.internaldafny.types.AES__GCM;

public class RawAESKeyring
implements VerifiableInterface,
IKeyring {
    public AtomicPrimitivesClient _cryptoPrimitives = null;
    public DafnySequence<? extends Byte> _wrappingKey = DafnySequence.empty(uint8._typeDescriptor());
    public AES__GCM _wrappingAlgorithm = null;
    public DafnySequence<? extends Byte> _keyNamespace = ValidUTF8Bytes.defaultValue();
    public DafnySequence<? extends Byte> _keyName = ValidUTF8Bytes.defaultValue();
    private static final TypeDescriptor<RawAESKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(RawAESKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out193 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out193;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out194 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out194;
    }

    public void __ctor(DafnySequence<? extends Byte> namespace, DafnySequence<? extends Byte> name, DafnySequence<? extends Byte> key, AES__GCM wrappingAlgorithm, AtomicPrimitivesClient cryptoPrimitives) {
        this._keyNamespace = namespace;
        this._keyName = name;
        this._wrappingKey = key;
        this._wrappingAlgorithm = wrappingAlgorithm;
        this._cryptoPrimitives = cryptoPrimitives;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        EncryptionMaterials _1101_materials = input.dtor_materials();
        AlgorithmSuiteInfo _1102_suite = _1101_materials.dtor_algorithmSuite();
        AesWrapKeyMaterial _nw45 = new AesWrapKeyMaterial();
        _nw45.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), this.cryptoPrimitives());
        AesWrapKeyMaterial _1103_wrap = _nw45;
        AesGenerateAndWrapKeyMaterial _nw46 = new AesGenerateAndWrapKeyMaterial();
        _nw46.__ctor(_1103_wrap);
        AesGenerateAndWrapKeyMaterial _1104_generateAndWrap = _nw46;
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Object> _1106_valueOrError0 = Result.Default(WrapEdkMaterialOutput.Default(AesWrapInfo.Default()));
        Result<WrapEdkMaterialOutput<AesWrapInfo>, Error> _out195 = EdkWrapping_Compile.__default.WrapEdkMaterial(AesWrapInfo._typeDescriptor(), _1101_materials, _1103_wrap, _1104_generateAndWrap);
        _1106_valueOrError0 = _out195;
        if (_1106_valueOrError0.IsFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor())) {
            output = _1106_valueOrError0.PropagateFailure(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return output;
        }
        WrapEdkMaterialOutput<AesWrapInfo> _1105_wrapOutput = _1106_valueOrError0.Extract(WrapEdkMaterialOutput._typeDescriptor(AesWrapInfo._typeDescriptor()), Error._typeDescriptor());
        Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _1107_symmetricSigningKeyList = _1105_wrapOutput.dtor_symmetricSigningKey().is_Some() ? Option.create_Some(DafnySequence.of((TypeDescriptor)DafnySequence._typeDescriptor(uint8._typeDescriptor()), (Object[])new DafnySequence[]{_1105_wrapOutput.dtor_symmetricSigningKey().dtor_value()})) : Option.create_None();
        EncryptedDataKey _1108_edk = EncryptedDataKey.create(this.keyNamespace(), this.SerializeProviderInfo(_1105_wrapOutput.dtor_wrapInfo().dtor_iv()), _1105_wrapOutput.dtor_wrappedMaterial());
        if (_1105_wrapOutput.is_GenerateAndWrapEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1110_valueOrError1 = null;
            _1110_valueOrError1 = Materials_Compile.__default.EncryptionMaterialAddDataKey(_1101_materials, _1105_wrapOutput.dtor_plaintextDataKey(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1108_edk}), _1107_symmetricSigningKeyList);
            if (_1110_valueOrError1.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1110_valueOrError1.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1109_result = _1110_valueOrError1.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1109_result));
            return output;
        }
        if (_1105_wrapOutput.is_WrapOnlyEdkMaterialOutput()) {
            Result<EncryptionMaterials, Error> _1112_valueOrError2 = null;
            _1112_valueOrError2 = Materials_Compile.__default.EncryptionMaterialAddEncryptedDataKeys(_1101_materials, (DafnySequence<? extends EncryptedDataKey>)DafnySequence.of(EncryptedDataKey._typeDescriptor(), (Object[])new EncryptedDataKey[]{_1108_edk}), _1107_symmetricSigningKeyList);
            if (_1112_valueOrError2.IsFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                output = _1112_valueOrError2.PropagateFailure(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return output;
            }
            EncryptionMaterials _1111_result = _1112_valueOrError2.Extract(EncryptionMaterials._typeDescriptor(), Error._typeDescriptor());
            output = Result.create_Success(OnEncryptOutput.create(_1111_result));
            return output;
        }
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> output = null;
        DecryptionMaterials _1113_materials = input.dtor_materials();
        Outcome<Object> _1114_valueOrError0 = Outcome.Default();
        _1114_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_1113_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_1114_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _1114_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        Result<Object, Object> _1116_valueOrError1 = Result.Default(DafnySequence.empty(uint8._typeDescriptor()));
        _1116_valueOrError1 = CanonicalEncryptionContext_Compile.__default.EncryptionContextToAAD(input.dtor_materials().dtor_encryptionContext());
        if (_1116_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor())) {
            output = _1116_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1115_aad = (DafnySequence)_1116_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(uint8._typeDescriptor()), Error._typeDescriptor());
        Outcome<Object> _1117_valueOrError2 = Outcome.Default();
        _1117_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Objects.equals(BigInteger.valueOf(this.wrappingKey().length()), BigInteger.valueOf(this.wrappingAlgorithm().dtor_keyLength())), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"The wrapping key does not match the wrapping algorithm")));
        if (_1117_valueOrError2.IsFailure(Error._typeDescriptor())) {
            output = _1117_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return output;
        }
        DafnySequence _1118_errors = DafnySequence.empty(Error._typeDescriptor());
        BigInteger _hi8 = BigInteger.valueOf(input.dtor_encryptedDataKeys().length());
        BigInteger _1119_i = BigInteger.ZERO;
        while (_1119_i.compareTo(_hi8) < 0) {
            if (this.ShouldDecryptEDK((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1119_i)))) {
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _out196;
                EncryptedDataKey _1120_edk = (EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1119_i));
                DafnySequence<? extends Byte> _1121_iv = this.GetIvFromProvInfo(_1120_edk.dtor_keyProviderInfo());
                AesUnwrapKeyMaterial _nw47 = new AesUnwrapKeyMaterial();
                _nw47.__ctor(this.wrappingKey(), this.wrappingAlgorithm(), _1121_iv, this.cryptoPrimitives());
                AesUnwrapKeyMaterial _1122_unwrap = _nw47;
                Result<UnwrapEdkMaterialOutput<AesUnwrapInfo>, Error> _1123_unwrapOutput = _out196 = EdkWrapping_Compile.__default.UnwrapEdkMaterial(AesUnwrapInfo._typeDescriptor(), _1120_edk.dtor_ciphertext(), _1113_materials, _1122_unwrap);
                if (_1123_unwrapOutput.is_Success()) {
                    Result<DecryptionMaterials, Error> _1125_valueOrError3 = null;
                    _1125_valueOrError3 = Materials_Compile.__default.DecryptionMaterialsAddDataKey(_1113_materials, _1123_unwrapOutput.dtor_value().dtor_plaintextDataKey(), _1123_unwrapOutput.dtor_value().dtor_symmetricSigningKey());
                    if (_1125_valueOrError3.IsFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor())) {
                        output = _1125_valueOrError3.PropagateFailure(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                        return output;
                    }
                    DecryptionMaterials _1124_result = _1125_valueOrError3.Extract(DecryptionMaterials._typeDescriptor(), Error._typeDescriptor());
                    OnDecryptOutput _1126_value = OnDecryptOutput.create(_1124_result);
                    output = Result.create_Success(_1126_value);
                    return output;
                }
                _1118_errors = DafnySequence.concatenate((DafnySequence)_1118_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_1123_unwrapOutput.dtor_error()}));
            } else {
                Result<Object, Object> _1128_valueOrError4 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
                _1128_valueOrError4 = UTF8.__default.Decode(((EncryptedDataKey)input.dtor_encryptedDataKeys().select(Helpers.toInt((BigInteger)_1119_i))).dtor_keyProviderId()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), _1129_e_boxed0 -> {
                    DafnySequence _1129_e = _1129_e_boxed0;
                    return Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_1129_e);
                });
                if (_1128_valueOrError4.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                    output = _1128_valueOrError4.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                    return output;
                }
                DafnySequence _1127_extractedKeyProviderId = (DafnySequence)_1128_valueOrError4.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
                _1118_errors = DafnySequence.concatenate((DafnySequence)_1118_errors, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{Error.create_AwsCryptographicMaterialProvidersException(ErrorMessages_Compile.__default.IncorrectRawDataKeys(String_Compile.__default.Base10Int2String(_1119_i), (DafnySequence<? extends Character>)DafnySequence.asString((String)"AESKeyring"), (DafnySequence<? extends Character>)_1127_extractedKeyProviderId))}));
            }
            _1119_i = _1119_i.add(BigInteger.ONE);
        }
        output = Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_1118_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"Raw AES Keyring was unable to decrypt any encrypted data key. The list of encountered Exceptions is avaible via `list`.")));
        return output;
    }

    public DafnySequence<? extends Byte> SerializeProviderInfo(DafnySequence<? extends Byte> iv) {
        return DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate((DafnySequence)DafnySequence.concatenate(this.keyName(), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_tagLength() * 8)), StandardLibrary_mUInt_Compile.__default.UInt32ToSeq(this.wrappingAlgorithm().dtor_ivLength())), iv);
    }

    public boolean ShouldDecryptEDK(EncryptedDataKey edk) {
        return edk.dtor_keyProviderId().equals(this.keyNamespace()) && this.ValidProviderInfo(edk.dtor_keyProviderInfo());
    }

    public boolean ValidProviderInfo(DafnySequence<? extends Byte> info) {
        return Objects.equals(BigInteger.valueOf(info.length()), BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()).add(BigInteger.valueOf(this.wrappingAlgorithm().dtor_ivLength()))) && info.subsequence(Helpers.toInt((BigInteger)BigInteger.ZERO), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()))).equals(this.keyName()) && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == 128 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())))) == this.wrappingAlgorithm().dtor_tagLength() * 8 && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == this.wrappingAlgorithm().dtor_ivLength() && StandardLibrary_mUInt_Compile.__default.SeqToUInt32((DafnySequence<? extends Byte>)info.subsequence(Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN())), Helpers.toInt((BigInteger)BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN())))) == 12;
    }

    public DafnySequence<? extends Byte> GetIvFromProvInfo(DafnySequence<? extends Byte> info) {
        return info.drop(BigInteger.valueOf(this.keyName().length()).add(__default.AUTH__TAG__LEN__LEN()).add(__default.IV__LEN__LEN()));
    }

    public AtomicPrimitivesClient cryptoPrimitives() {
        return this._cryptoPrimitives;
    }

    public DafnySequence<? extends Byte> wrappingKey() {
        return this._wrappingKey;
    }

    public AES__GCM wrappingAlgorithm() {
        return this._wrappingAlgorithm;
    }

    public DafnySequence<? extends Byte> keyNamespace() {
        return this._keyNamespace;
    }

    public DafnySequence<? extends Byte> keyName() {
        return this._keyName;
    }

    public static TypeDescriptor<RawAESKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "RawAESKeyring.RawAESKeyring";
    }
}

