/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import Constants_Compile.__default;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class OnDecryptEncryptedDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    private static final TypeDescriptor<OnDecryptEncryptedDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(OnDecryptEncryptedDataKeyFilter.class, () -> null);

    public void __ctor(DafnySequence<? extends Character> awsKmsKey) {
        this._awsKmsKey = awsKmsKey;
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> res = Result.Default(false);
        if (!edk.dtor_keyProviderId().equals(__default.PROVIDER__ID())) {
            res = Result.create_Success(false);
            return res;
        }
        if (!UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo())) {
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS encoding, provider info is not UTF8.")));
            return res;
        }
        Result<Object, Object> _588_valueOrError0 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _588_valueOrError0 = UTF8.__default.Decode(edk.dtor_keyProviderInfo()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_588_valueOrError0.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            res = _588_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        DafnySequence _587_keyId = (DafnySequence)_588_valueOrError0.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<AwsArn, Error> _590_valueOrError1 = null;
        _590_valueOrError1 = AwsArnParsing_Compile.__default.ParseAwsKmsArn((DafnySequence<? extends Character>)_587_keyId).MapFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_590_valueOrError1.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
            res = _590_valueOrError1.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return res;
        }
        AwsArn _589___v0 = _590_valueOrError1.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
        res = Result.create_Success(this.awsKmsKey().equals((Object)_587_keyId));
        return res;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public static TypeDescriptor<OnDecryptEncryptedDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.OnDecryptEncryptedDataKeyFilter";
    }
}

