/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsKeyring_Compile;

import Actions_Compile.Action;
import Actions_Compile.ActionWithResult;
import AwsKmsKeyring_Compile.KmsWrapInfo;
import MaterialWrapping_Compile.WrapInput;
import MaterialWrapping_Compile.WrapMaterial;
import MaterialWrapping_Compile.WrapOutput;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.__default;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptRequest;
import software.amazon.cryptography.services.kms.internaldafny.types.EncryptResponse;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class KmsWrapKeyMaterial
implements WrapMaterial<KmsWrapInfo>,
ActionWithResult<WrapInput, WrapOutput<KmsWrapInfo>, Error>,
Action<WrapInput, Result<WrapOutput<KmsWrapInfo>, Error>> {
    public IKMSClient _client = null;
    public DafnySequence<? extends Character> _awsKmsKey = DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR);
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<KmsWrapKeyMaterial> _TYPE = TypeDescriptor.referenceWithInitializer(KmsWrapKeyMaterial.class, () -> null);

    public void __ctor(IKMSClient client, DafnySequence<? extends Character> awsKmsKey, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._awsKmsKey = awsKmsKey;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<WrapOutput<KmsWrapInfo>, Error> Invoke(WrapInput input) {
        Result<EncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _out89;
        Result<WrapOutput<KmsWrapInfo>, Error> res = Result.Default(WrapOutput.Default(KmsWrapInfo.Default()));
        AlgorithmSuiteInfo _619_suite = input.dtor_algorithmSuite();
        Result<Object, Object> _621_valueOrError0 = Result.Default(DafnyMap.empty());
        _621_valueOrError0 = AwsKmsUtils_Compile.__default.StringifyEncryptionContext(input.dtor_encryptionContext());
        if (_621_valueOrError0.IsFailure((TypeDescriptor<DafnyMap>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor())) {
            res = _621_valueOrError0.PropagateFailure((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        DafnyMap _620_stringifiedEncCtx = (DafnyMap)_621_valueOrError0.Extract((TypeDescriptor<Object>)DafnyMap._typeDescriptor((TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR)), Error._typeDescriptor());
        Outcome<Object> _622_valueOrError1 = Outcome.Default();
        _622_valueOrError1 = __default.Need(Error._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.__default.IsValid__PlaintextType(input.dtor_plaintextMaterial()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid Plaintext on KMS Encrypt")));
        if (_622_valueOrError1.IsFailure(Error._typeDescriptor())) {
            res = _622_valueOrError1.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        EncryptRequest _623_encryptRequest = EncryptRequest.create(this.awsKmsKey(), input.dtor_plaintextMaterial(), Option.create_Some(_620_stringifiedEncCtx), Option.create_Some(this.grantTokens()), Option.create_None());
        Result<EncryptResponse, software.amazon.cryptography.services.kms.internaldafny.types.Error> _624_maybeEncryptResponse = _out89 = this.client().Encrypt(_623_encryptRequest);
        Result<EncryptResponse, Object> _626_valueOrError2 = Result.Default(EncryptResponse.Default());
        _626_valueOrError2 = _624_maybeEncryptResponse.MapFailure(EncryptResponse._typeDescriptor(), software.amazon.cryptography.services.kms.internaldafny.types.Error._typeDescriptor(), Error._typeDescriptor(), _627_e_boxed0 -> {
            software.amazon.cryptography.services.kms.internaldafny.types.Error _627_e = _627_e_boxed0;
            return Error.create_ComAmazonawsKms(_627_e);
        });
        if (_626_valueOrError2.IsFailure(EncryptResponse._typeDescriptor(), Error._typeDescriptor())) {
            res = _626_valueOrError2.PropagateFailure(EncryptResponse._typeDescriptor(), Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        EncryptResponse _625_encryptResponse = _626_valueOrError2.Extract(EncryptResponse._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _628_valueOrError3 = Outcome.Default();
        _628_valueOrError3 = __default.Need(Error._typeDescriptor(), _625_encryptResponse.dtor_KeyId().is_Some() && AwsArnParsing_Compile.__default.ParseAwsKmsIdentifier(_625_encryptResponse.dtor_KeyId().dtor_value()).is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Encrypt:: Invalid Key Id")));
        if (_628_valueOrError3.IsFailure(Error._typeDescriptor())) {
            res = _628_valueOrError3.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        Outcome<Object> _629_valueOrError4 = Outcome.Default();
        _629_valueOrError4 = __default.Need(Error._typeDescriptor(), _625_encryptResponse.dtor_CiphertextBlob().is_Some(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid response from AWS KMS Encrypt: Invalid Ciphertext Blob")));
        if (_629_valueOrError4.IsFailure(Error._typeDescriptor())) {
            res = _629_valueOrError4.PropagateFailure(Error._typeDescriptor(), WrapOutput._typeDescriptor(KmsWrapInfo._typeDescriptor()));
            return res;
        }
        WrapOutput<KmsWrapInfo> _630_output = WrapOutput.create(_625_encryptResponse.dtor_CiphertextBlob().dtor_value(), KmsWrapInfo.create(_625_encryptResponse.dtor_KeyId().dtor_value()));
        res = Result.create_Success(_630_output);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public DafnySequence<? extends Character> awsKmsKey() {
        return this._awsKmsKey;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<KmsWrapKeyMaterial> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsKeyring.KmsWrapKeyMaterial";
    }
}

