/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.DeterministicAction;
import Actions_Compile.DeterministicActionWithResult;
import AwsArnParsing_Compile.AwsArn;
import AwsArnParsing_Compile.AwsKmsArn;
import AwsKmsDiscoveryKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.TypeDescriptor;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;

public class AwsKmsEncryptedDataKeyFilter
implements DeterministicActionWithResult<EncryptedDataKey, Boolean, Error>,
DeterministicAction<EncryptedDataKey, Result<Boolean, Error>> {
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    private static final TypeDescriptor<AwsKmsEncryptedDataKeyFilter> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsEncryptedDataKeyFilter.class, () -> null);

    public void __ctor(Option<DiscoveryFilter> discoveryFilter) {
        this._discoveryFilter = discoveryFilter;
    }

    @Override
    public Result<Boolean, Error> Invoke(EncryptedDataKey edk) {
        Result<Boolean, Error> output = Result.Default(false);
        Outcome<Object> _678_valueOrError0 = Outcome.Default();
        _678_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), UTF8.__default.ValidUTF8Seq(edk.dtor_keyProviderInfo()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Invalid AWS KMS encoding, provider info is not UTF8.")));
        if (_678_valueOrError0.IsFailure(Error._typeDescriptor())) {
            output = _678_valueOrError0.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return output;
        }
        Result<Object, Object> _680_valueOrError1 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
        _680_valueOrError1 = UTF8.__default.Decode(edk.dtor_keyProviderInfo()).MapFailure((TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_680_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
            output = _680_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return output;
        }
        DafnySequence _679_keyId = (DafnySequence)_680_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
        Result<AwsArn, Error> _682_valueOrError2 = null;
        _682_valueOrError2 = AwsArnParsing_Compile.__default.ParseAwsKmsArn((DafnySequence<? extends Character>)_679_keyId).MapFailure(AwsKmsArn._typeDescriptor(), (TypeDescriptor<DafnySequence<? extends Character>>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), AwsKmsUtils_Compile.__default::WrapStringToError);
        if (_682_valueOrError2.IsFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor())) {
            output = _682_valueOrError2.PropagateFailure(AwsKmsArn._typeDescriptor(), Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return output;
        }
        AwsArn _681_arn = _682_valueOrError2.Extract(AwsKmsArn._typeDescriptor(), Error._typeDescriptor());
        Outcome<Object> _683_valueOrError3 = Outcome.Default();
        _683_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _681_arn.dtor_resource().dtor_resourceType().equals((Object)DafnySequence.asString((String)"key")), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Only AWS KMS Keys supported")));
        if (_683_valueOrError3.IsFailure(Error._typeDescriptor())) {
            output = _683_valueOrError3.PropagateFailure(Error._typeDescriptor(), TypeDescriptor.BOOLEAN);
            return output;
        }
        if (!edk.dtor_keyProviderId().equals(Constants_Compile.__default.PROVIDER__ID())) {
            output = Result.create_Success(false);
            return output;
        }
        if (!__default.DiscoveryMatch(_681_arn, this.discoveryFilter())) {
            output = Result.create_Success(false);
            return output;
        }
        output = Result.create_Success(true);
        return output;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public static TypeDescriptor<AwsKmsEncryptedDataKeyFilter> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring.AwsKmsEncryptedDataKeyFilter";
    }
}

