/*
 * Decompiled with CFR 0.152.
 */
package AwsKmsDiscoveryKeyring_Compile;

import Actions_Compile.__default;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyDecryptor;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyFilter;
import AwsKmsDiscoveryKeyring_Compile.AwsKmsEncryptedDataKeyTransformer;
import Constants_Compile.AwsKmsEdkHelper;
import Keyring_Compile.VerifiableInterface;
import Materials_Compile.SealedDecryptionMaterials;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import Wrappers_Compile.Result_Failure;
import Wrappers_Compile.Result_Success;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import java.util.function.Function;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.DiscoveryFilter;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;
import software.amazon.cryptography.services.kms.internaldafny.types.GrantTokenType;
import software.amazon.cryptography.services.kms.internaldafny.types.IKMSClient;

public class AwsKmsDiscoveryKeyring
implements VerifiableInterface,
IKeyring {
    public IKMSClient _client = null;
    public Option<DiscoveryFilter> _discoveryFilter = Option.Default();
    public DafnySequence<? extends DafnySequence<? extends Character>> _grantTokens = DafnySequence.empty(GrantTokenType._typeDescriptor());
    private static final TypeDescriptor<AwsKmsDiscoveryKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(AwsKmsDiscoveryKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out92 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out92;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out93 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out93;
    }

    public void __ctor(IKMSClient client, Option<DiscoveryFilter> discoveryFilter, DafnySequence<? extends DafnySequence<? extends Character>> grantTokens) {
        this._client = client;
        this._discoveryFilter = discoveryFilter;
        this._grantTokens = grantTokens;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> output = null;
        output = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Encryption is not supported with a Discovery Keyring.")));
        return output;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<DecryptionMaterials, DafnySequence<Error>> _out96;
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _660_materials = input.dtor_materials();
        DafnySequence<? extends EncryptedDataKey> _661_encryptedDataKeys = input.dtor_encryptedDataKeys();
        AlgorithmSuiteInfo _662_suite = input.dtor_materials().dtor_algorithmSuite();
        Outcome<Object> _663_valueOrError0 = Outcome.Default();
        _663_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(_660_materials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_663_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _663_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        AwsKmsEncryptedDataKeyFilter _nw9 = new AwsKmsEncryptedDataKeyFilter();
        _nw9.__ctor(this.discoveryFilter());
        AwsKmsEncryptedDataKeyFilter _664_edkFilter = _nw9;
        Result<Object, Object> _666_valueOrError1 = Result.Default(DafnySequence.empty(EncryptedDataKey._typeDescriptor()));
        Result<DafnySequence<? extends EncryptedDataKey>, Error> _out94 = __default.FilterWithResult(EncryptedDataKey._typeDescriptor(), Error._typeDescriptor(), _664_edkFilter, _661_encryptedDataKeys);
        _666_valueOrError1 = _out94;
        if (_666_valueOrError1.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor())) {
            res = _666_valueOrError1.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _665_matchingEdks = (DafnySequence)_666_valueOrError1.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(EncryptedDataKey._typeDescriptor()), Error._typeDescriptor());
        AwsKmsEncryptedDataKeyTransformer _nw10 = new AwsKmsEncryptedDataKeyTransformer();
        _nw10.__ctor();
        AwsKmsEncryptedDataKeyTransformer _667_edkTransform = _nw10;
        Result<Object, Object> _669_valueOrError2 = Result.Default(DafnySequence.empty(AwsKmsEdkHelper._typeDescriptor()));
        Result<DafnySequence<? extends AwsKmsEdkHelper>, Error> _out95 = __default.DeterministicFlatMapWithResult(EncryptedDataKey._typeDescriptor(), AwsKmsEdkHelper._typeDescriptor(), Error._typeDescriptor(), _667_edkTransform, _665_matchingEdks);
        _669_valueOrError2 = _out95;
        if (_669_valueOrError2.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor())) {
            res = _669_valueOrError2.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _668_edksToAttempt = (DafnySequence)_669_valueOrError2.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor(AwsKmsEdkHelper._typeDescriptor()), Error._typeDescriptor());
        if (BigInteger.valueOf(_668_edksToAttempt.length()).signum() == 0) {
            Result<Object, Object> _671_valueOrError3 = Result.Default(DafnySequence.empty((TypeDescriptor)TypeDescriptor.CHAR));
            _671_valueOrError3 = ErrorMessages_Compile.__default.IncorrectDataKeys(input.dtor_encryptedDataKeys(), input.dtor_materials().dtor_algorithmSuite(), (DafnySequence<? extends Character>)DafnySequence.asString((String)""));
            if (_671_valueOrError3.IsFailure((TypeDescriptor<DafnySequence>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor())) {
                res = _671_valueOrError3.PropagateFailure((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
                return res;
            }
            DafnySequence _670_errorMessage = (DafnySequence)_671_valueOrError3.Extract((TypeDescriptor<Object>)DafnySequence._typeDescriptor((TypeDescriptor)TypeDescriptor.CHAR), Error._typeDescriptor());
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_670_errorMessage));
            return res;
        }
        AwsKmsEncryptedDataKeyDecryptor _nw11 = new AwsKmsEncryptedDataKeyDecryptor();
        _nw11.__ctor(_660_materials, this.client(), this.grantTokens());
        AwsKmsEncryptedDataKeyDecryptor _672_decryptAction = _nw11;
        Result<DecryptionMaterials, DafnySequence<Error>> _673_outcome = _out96 = __default.ReduceToSuccess(AwsKmsEdkHelper._typeDescriptor(), SealedDecryptionMaterials._typeDescriptor(), Error._typeDescriptor(), _672_decryptAction, _668_edksToAttempt);
        res = ((Function<Result, Result>)_source24_boxed0 -> {
            Result _source24 = _source24_boxed0;
            if (_source24.is_Success()) {
                DecryptionMaterials _674___mcc_h0 = (DecryptionMaterials)((Result_Success)_source24)._value;
                return (Result)Helpers.Let((Object)_674___mcc_h0, boxed26 -> {
                    DecryptionMaterials _pat_let13_0 = boxed26;
                    return (Result)Helpers.Let((Object)_pat_let13_0, boxed27 -> {
                        DecryptionMaterials _675_mat = boxed27;
                        return Result.create_Success(OnDecryptOutput.create(_675_mat));
                    });
                });
            }
            DafnySequence _676___mcc_h1 = (DafnySequence)((Result_Failure)_source24)._error;
            return (Result)Helpers.Let((Object)_676___mcc_h1, boxed28 -> {
                DafnySequence _pat_let14_0 = boxed28;
                return (Result)Helpers.Let((Object)_pat_let14_0, boxed29 -> {
                    DafnySequence _677_errors = boxed29;
                    return Result.create_Failure(Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_677_errors, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured KMS Key was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`.")));
                });
            });
        }).apply(_673_outcome);
        return res;
    }

    public IKMSClient client() {
        return this._client;
    }

    public Option<DiscoveryFilter> discoveryFilter() {
        return this._discoveryFilter;
    }

    public DafnySequence<? extends DafnySequence<? extends Character>> grantTokens() {
        return this._grantTokens;
    }

    public static TypeDescriptor<AwsKmsDiscoveryKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "AwsKmsDiscoveryKeyring.AwsKmsDiscoveryKeyring";
    }
}

