/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.internaldafny.types;

import UTF8.ValidUTF8Bytes;
import Wrappers_Compile.Option;
import dafny.DafnyMap;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.util.Objects;
import software.amazon.cryptography.materialproviders.internaldafny.types.AlgorithmSuiteInfo;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptedDataKey;

public class EncryptionMaterials {
    public AlgorithmSuiteInfo _algorithmSuite;
    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> _encryptionContext;
    public DafnySequence<? extends EncryptedDataKey> _encryptedDataKeys;
    public DafnySequence<? extends DafnySequence<? extends Byte>> _requiredEncryptionContextKeys;
    public Option<DafnySequence<? extends Byte>> _plaintextDataKey;
    public Option<DafnySequence<? extends Byte>> _signingKey;
    public Option<DafnySequence<? extends DafnySequence<? extends Byte>>> _symmetricSigningKeys;
    private static final EncryptionMaterials theDefault = EncryptionMaterials.create(AlgorithmSuiteInfo.Default(), (DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>>)DafnyMap.empty(), (DafnySequence<? extends EncryptedDataKey>)DafnySequence.empty(EncryptedDataKey._typeDescriptor()), (DafnySequence<? extends DafnySequence<? extends Byte>>)DafnySequence.empty(ValidUTF8Bytes._typeDescriptor()), Option.Default(), Option.Default(), Option.Default());
    private static final TypeDescriptor<EncryptionMaterials> _TYPE = TypeDescriptor.referenceWithInitializer(EncryptionMaterials.class, () -> EncryptionMaterials.Default());

    public EncryptionMaterials(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> signingKey, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeys) {
        this._algorithmSuite = algorithmSuite;
        this._encryptionContext = encryptionContext;
        this._encryptedDataKeys = encryptedDataKeys;
        this._requiredEncryptionContextKeys = requiredEncryptionContextKeys;
        this._plaintextDataKey = plaintextDataKey;
        this._signingKey = signingKey;
        this._symmetricSigningKeys = symmetricSigningKeys;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        EncryptionMaterials o = (EncryptionMaterials)other;
        return Objects.equals(this._algorithmSuite, o._algorithmSuite) && Objects.equals(this._encryptionContext, o._encryptionContext) && Objects.equals(this._encryptedDataKeys, o._encryptedDataKeys) && Objects.equals(this._requiredEncryptionContextKeys, o._requiredEncryptionContextKeys) && Objects.equals(this._plaintextDataKey, o._plaintextDataKey) && Objects.equals(this._signingKey, o._signingKey) && Objects.equals(this._symmetricSigningKeys, o._symmetricSigningKeys);
    }

    public int hashCode() {
        long hash = 5381L;
        hash = (hash << 5) + hash + 0L;
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._algorithmSuite);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptionContext);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._encryptedDataKeys);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._requiredEncryptionContextKeys);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._plaintextDataKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._signingKey);
        hash = (hash << 5) + hash + (long)Objects.hashCode(this._symmetricSigningKeys);
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("AwsCryptographyMaterialProvidersTypes.EncryptionMaterials.EncryptionMaterials");
        s.append("(");
        s.append(Helpers.toString((Object)this._algorithmSuite));
        s.append(", ");
        s.append(Helpers.toString(this._encryptionContext));
        s.append(", ");
        s.append(Helpers.toString(this._encryptedDataKeys));
        s.append(", ");
        s.append(Helpers.toString(this._requiredEncryptionContextKeys));
        s.append(", ");
        s.append(Helpers.toString(this._plaintextDataKey));
        s.append(", ");
        s.append(Helpers.toString(this._signingKey));
        s.append(", ");
        s.append(Helpers.toString(this._symmetricSigningKeys));
        s.append(")");
        return s.toString();
    }

    public static EncryptionMaterials Default() {
        return theDefault;
    }

    public static TypeDescriptor<EncryptionMaterials> _typeDescriptor() {
        return _TYPE;
    }

    public static EncryptionMaterials create(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> signingKey, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeys) {
        return new EncryptionMaterials(algorithmSuite, encryptionContext, encryptedDataKeys, requiredEncryptionContextKeys, plaintextDataKey, signingKey, symmetricSigningKeys);
    }

    public static EncryptionMaterials create_EncryptionMaterials(AlgorithmSuiteInfo algorithmSuite, DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> encryptionContext, DafnySequence<? extends EncryptedDataKey> encryptedDataKeys, DafnySequence<? extends DafnySequence<? extends Byte>> requiredEncryptionContextKeys, Option<DafnySequence<? extends Byte>> plaintextDataKey, Option<DafnySequence<? extends Byte>> signingKey, Option<DafnySequence<? extends DafnySequence<? extends Byte>>> symmetricSigningKeys) {
        return EncryptionMaterials.create(algorithmSuite, encryptionContext, encryptedDataKeys, requiredEncryptionContextKeys, plaintextDataKey, signingKey, symmetricSigningKeys);
    }

    public boolean is_EncryptionMaterials() {
        return true;
    }

    public AlgorithmSuiteInfo dtor_algorithmSuite() {
        return this._algorithmSuite;
    }

    public DafnyMap<? extends DafnySequence<? extends Byte>, ? extends DafnySequence<? extends Byte>> dtor_encryptionContext() {
        return this._encryptionContext;
    }

    public DafnySequence<? extends EncryptedDataKey> dtor_encryptedDataKeys() {
        return this._encryptedDataKeys;
    }

    public DafnySequence<? extends DafnySequence<? extends Byte>> dtor_requiredEncryptionContextKeys() {
        return this._requiredEncryptionContextKeys;
    }

    public Option<DafnySequence<? extends Byte>> dtor_plaintextDataKey() {
        return this._plaintextDataKey;
    }

    public Option<DafnySequence<? extends Byte>> dtor_signingKey() {
        return this._signingKey;
    }

    public Option<DafnySequence<? extends DafnySequence<? extends Byte>>> dtor_symmetricSigningKeys() {
        return this._symmetricSigningKeys;
    }
}

