/*
 * Decompiled with CFR 0.152.
 */
package MultiKeyring_Compile;

import Keyring_Compile.VerifiableInterface;
import MultiKeyring_Compile.__default;
import Wrappers_Compile.Option;
import Wrappers_Compile.Outcome;
import Wrappers_Compile.Result;
import dafny.DafnySequence;
import dafny.Helpers;
import dafny.TypeDescriptor;
import java.math.BigInteger;
import software.amazon.cryptography.materialproviders.internaldafny.types.DecryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.EncryptionMaterials;
import software.amazon.cryptography.materialproviders.internaldafny.types.Error;
import software.amazon.cryptography.materialproviders.internaldafny.types.IKeyring;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnDecryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptInput;
import software.amazon.cryptography.materialproviders.internaldafny.types.OnEncryptOutput;
import software.amazon.cryptography.materialproviders.internaldafny.types._Companion_IKeyring;

public class MultiKeyring
implements VerifiableInterface,
IKeyring {
    public Option<IKeyring> _generatorKeyring = Option.Default();
    public DafnySequence<? extends IKeyring> _childKeyrings = DafnySequence.empty(_Companion_IKeyring._typeDescriptor());
    private static final TypeDescriptor<MultiKeyring> _TYPE = TypeDescriptor.referenceWithInitializer(MultiKeyring.class, () -> null);

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> _out55 = _Companion_IKeyring.OnEncrypt(this, input);
        return _out55;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> _out56 = _Companion_IKeyring.OnDecrypt(this, input);
        return _out56;
    }

    public void __ctor(Option<IKeyring> generatorKeyring, DafnySequence<? extends IKeyring> childKeyrings) {
        this._generatorKeyring = generatorKeyring;
        this._childKeyrings = childKeyrings;
    }

    @Override
    public Result<OnEncryptOutput, Error> OnEncrypt_k(OnEncryptInput input) {
        Result<OnEncryptOutput, Error> res = null;
        if (this.generatorKeyring().is_None() && input.dtor_materials().dtor_plaintextDataKey().is_None()) {
            DafnySequence _377_exception = DafnySequence.asString((String)"Need either a generator keyring or input encryption materials which contain a plaintext data key");
            res = Result.create_Failure(Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)_377_exception));
            return res;
        }
        EncryptionMaterials _378_returnMaterials = input.dtor_materials();
        if (this.generatorKeyring().is_Some()) {
            Result<OnEncryptOutput, Error> _out57;
            Outcome<Object> _379_valueOrError0 = Outcome.Default();
            _379_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), input.dtor_materials().dtor_plaintextDataKey().is_None(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"This multi keyring has a generator but provided Encryption Materials already contain plaintext data key")));
            if (_379_valueOrError0.IsFailure(Error._typeDescriptor())) {
                res = _379_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Result<OnEncryptOutput, Error> _380_onEncryptOutput = _out57 = this.generatorKeyring().dtor_value().OnEncrypt(input);
            Outcome<Object> _381_valueOrError1 = Outcome.Default();
            _381_valueOrError1 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _380_onEncryptOutput.is_Success(), _380_onEncryptOutput.is_Failure() ? _380_onEncryptOutput.dtor_error() : Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Unexpected failure. Input to Need is !Success.")));
            if (_381_valueOrError1.IsFailure(Error._typeDescriptor())) {
                res = _381_valueOrError1.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _382_valueOrError2 = Outcome.Default();
            _382_valueOrError2 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _380_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Generator keyring returned invalid encryption materials")));
            if (_382_valueOrError2.IsFailure(Error._typeDescriptor())) {
                res = _382_valueOrError2.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _378_returnMaterials = _380_onEncryptOutput.dtor_value().dtor_materials();
        }
        BigInteger _hi0 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _383_i = BigInteger.ZERO;
        while (_383_i.compareTo(_hi0) < 0) {
            Result<OnEncryptOutput, Error> _out58;
            OnEncryptInput _384_onEncryptInput = OnEncryptInput.create(_378_returnMaterials);
            Result<OnEncryptOutput, Error> _385_onEncryptOutput = _out58 = ((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_383_i))).OnEncrypt(_384_onEncryptInput);
            Outcome<Object> _386_valueOrError3 = Outcome.Default();
            _386_valueOrError3 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), _385_onEncryptOutput.is_Success(), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring failed to encrypt plaintext data key")));
            if (_386_valueOrError3.IsFailure(Error._typeDescriptor())) {
                res = _386_valueOrError3.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            Outcome<Object> _387_valueOrError4 = Outcome.Default();
            _387_valueOrError4 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(_378_returnMaterials, _385_onEncryptOutput.dtor_value().dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Child keyring performed invalid transition on encryption materials")));
            if (_387_valueOrError4.IsFailure(Error._typeDescriptor())) {
                res = _387_valueOrError4.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
                return res;
            }
            _378_returnMaterials = _385_onEncryptOutput.dtor_value().dtor_materials();
            _383_i = _383_i.add(BigInteger.ONE);
        }
        Outcome<Object> _388_valueOrError5 = Outcome.Default();
        _388_valueOrError5 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.ValidEncryptionMaterialsTransition(input.dtor_materials(), _378_returnMaterials), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"A child or generator keyring modified the encryption materials in illegal ways.")));
        if (_388_valueOrError5.IsFailure(Error._typeDescriptor())) {
            res = _388_valueOrError5.PropagateFailure(Error._typeDescriptor(), OnEncryptOutput._typeDescriptor());
            return res;
        }
        res = Result.create_Success(OnEncryptOutput.create(_378_returnMaterials));
        return res;
    }

    @Override
    public Result<OnDecryptOutput, Error> OnDecrypt_k(OnDecryptInput input) {
        Result<OnDecryptOutput, Error> res = null;
        DecryptionMaterials _389_materials = input.dtor_materials();
        Outcome<Object> _390_valueOrError0 = Outcome.Default();
        _390_valueOrError0 = Wrappers_Compile.__default.Need(Error._typeDescriptor(), Materials_Compile.__default.DecryptionMaterialsWithoutPlaintextDataKey(input.dtor_materials()), Error.create_AwsCryptographicMaterialProvidersException((DafnySequence<? extends Character>)DafnySequence.asString((String)"Keyring received decryption materials that already contain a plaintext data key.")));
        if (_390_valueOrError0.IsFailure(Error._typeDescriptor())) {
            res = _390_valueOrError0.PropagateFailure(Error._typeDescriptor(), OnDecryptOutput._typeDescriptor());
            return res;
        }
        DafnySequence _391_failures = DafnySequence.empty(Error._typeDescriptor());
        if (this.generatorKeyring().is_Some()) {
            Result<OnDecryptOutput, Error> _out59 = __default.AttemptDecryptDataKey(this.generatorKeyring().dtor_value(), input);
            Result<OnDecryptOutput, Error> _392_result = _out59;
            if (_392_result.is_Success()) {
                if (_392_result.dtor_value().dtor_materials().dtor_plaintextDataKey().is_Some()) {
                    res = Result.create_Success(_392_result.dtor_value());
                    return res;
                }
            } else {
                _391_failures = DafnySequence.concatenate((DafnySequence)_391_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_392_result.dtor_error()}));
            }
        }
        BigInteger _hi1 = BigInteger.valueOf(this.childKeyrings().length());
        BigInteger _393_j = BigInteger.ZERO;
        while (_393_j.compareTo(_hi1) < 0) {
            Result<OnDecryptOutput, Error> _out60 = __default.AttemptDecryptDataKey((IKeyring)this.childKeyrings().select(Helpers.toInt((BigInteger)_393_j)), input);
            Result<OnDecryptOutput, Error> _394_result = _out60;
            if (_394_result.is_Success()) {
                res = Result.create_Success(_394_result.dtor_value());
                return res;
            }
            _391_failures = DafnySequence.concatenate((DafnySequence)_391_failures, (DafnySequence)DafnySequence.of(Error._typeDescriptor(), (Object[])new Error[]{_394_result.dtor_error()}));
            _393_j = _393_j.add(BigInteger.ONE);
        }
        Error _395_combinedResult = Error.create_CollectionOfErrors((DafnySequence<? extends Error>)_391_failures, (DafnySequence<? extends Character>)DafnySequence.asString((String)"No Configured Keyring was able to decrypt the Data Key. The list of encountered Exceptions is available via `list`."));
        res = Result.create_Failure(_395_combinedResult);
        return res;
    }

    public Option<IKeyring> generatorKeyring() {
        return this._generatorKeyring;
    }

    public DafnySequence<? extends IKeyring> childKeyrings() {
        return this._childKeyrings;
    }

    public static TypeDescriptor<MultiKeyring> _typeDescriptor() {
        return _TYPE;
    }

    public String toString() {
        return "MultiKeyring.MultiKeyring";
    }
}

